/*
 * Decompiled with CFR 0.152.
 */
package org.savara.monitor.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.savara.common.config.Configuration;
import org.savara.monitor.ConversationInstanceId;
import org.savara.monitor.SessionStore;
import org.savara.protocol.ProtocolId;

public class InMemorySessionStore
implements SessionStore {
    private Map<ProtocolId, Map<ConversationInstanceId, Serializable>> m_sessions = new HashMap<ProtocolId, Map<ConversationInstanceId, Serializable>>();

    public void setConfiguration(Configuration config) {
    }

    protected void addSession(ProtocolId pid, ConversationInstanceId cid, Serializable session) {
        Map<ConversationInstanceId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions == null) {
            sessions = new HashMap<ConversationInstanceId, Serializable>();
            this.m_sessions.put(pid, sessions);
        } else if (sessions.containsKey(cid)) {
            throw new IllegalArgumentException("Conversation instance id already in use");
        }
        sessions.put(cid, session);
    }

    public Serializable create(ProtocolId pid, ConversationInstanceId cid, Serializable session) {
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        this.addSession(pid, cid, session);
        return session;
    }

    public Serializable find(ProtocolId pid, ConversationInstanceId cid) {
        Serializable ret = null;
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        Map<ConversationInstanceId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions != null) {
            ret = sessions.get(cid);
        }
        return ret;
    }

    public void remove(ProtocolId pid, ConversationInstanceId cid) {
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        Map<ConversationInstanceId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions == null || !sessions.containsKey(cid)) {
            throw new IllegalArgumentException("Conversation instance id is unknown");
        }
        sessions.remove(cid);
        if (sessions.size() == 0) {
            this.m_sessions.remove(pid);
        }
    }

    public void update(ProtocolId pid, ConversationInstanceId cid, Serializable session) {
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        Map<ConversationInstanceId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions == null || !sessions.containsKey(cid)) {
            throw new IllegalArgumentException("Conversation instance id unknown");
        }
        sessions.put(cid, session);
    }

    public void close() {
    }
}

