/*
 * Decompiled with CFR 0.152.
 */
package org.savara.monitor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.monitor.ConversationId;
import org.savara.monitor.ConversationResolver;
import org.savara.monitor.DefautMonitorContext;
import org.savara.monitor.DescriptionCache;
import org.savara.monitor.Message;
import org.savara.monitor.Monitor;
import org.savara.monitor.MonitorResult;
import org.savara.monitor.SessionStore;
import org.savara.protocol.ProtocolCriteria;
import org.savara.protocol.ProtocolId;
import org.savara.protocol.export.monitor.ForkJoinMonitorExportVisitor;
import org.savara.protocol.repository.ProtocolRepository;
import org.scribble.common.logging.CachedJournal;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.export.monitor.MonitorExportVisitor;
import org.scribble.protocol.export.monitor.MonitorProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.monitor.DefaultProtocolMonitor;
import org.scribble.protocol.monitor.DefaultSession;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Description;
import org.scribble.protocol.monitor.util.MonitorModelUtil;

public class DefaultMonitor
implements Monitor {
    private ProtocolRepository m_protocolRepository = null;
    private SessionStore m_sessionStore = null;
    private ConversationResolver m_conversationResolver = null;
    private ProtocolMonitor m_monitor = new DefaultProtocolMonitor();
    private DescriptionCache m_descriptionCache = new DescriptionCache();
    private MonitorProtocolExporter m_exporter = new MonitorProtocolExporter();
    private MonitorContext _context = new DefautMonitorContext();
    private static final Logger logger = Logger.getLogger(DefaultMonitor.class.getName());

    public DefaultMonitor() {
        this.m_exporter.setMonitorExportVisitor((MonitorExportVisitor)new ForkJoinMonitorExportVisitor());
    }

    public void setMonitorContext(MonitorContext context) {
        this._context = context;
    }

    public MonitorContext getMonitorContext() {
        return this._context;
    }

    public void setProtocolMonitor(ProtocolMonitor pm) {
        this.m_monitor = pm;
    }

    public void setProtocolRepository(ProtocolRepository rep) {
        this.m_protocolRepository = rep;
    }

    public void setSessionStore(SessionStore store) {
        this.m_sessionStore = store;
    }

    public void setConversationResolver(ConversationResolver resolver) {
        this.m_conversationResolver = resolver;
    }

    public MonitorResult process(ProtocolId pid, ConversationId cid, Message mesg) {
        MonitorResult ret = null;
        boolean messageRelevant = false;
        ConversationId unhandledCID = null;
        if (this.m_protocolRepository == null) {
            throw new IllegalStateException("Protocol repository has not been configured");
        }
        if (this.m_sessionStore == null) {
            throw new IllegalStateException("Session store has not been configured");
        }
        if (pid == null) {
            List pids = this.m_protocolRepository.getProtocols((ProtocolCriteria)mesg);
            if (pids != null) {
                for (ProtocolId pi : pids) {
                    Description desc = this.getProtocolDescription(pi);
                    ConversationId lcid = cid;
                    if (lcid == null && this.m_conversationResolver != null) {
                        lcid = this.m_conversationResolver.getConversationId(desc, mesg);
                    }
                    if (lcid == null) continue;
                    messageRelevant = true;
                    unhandledCID = lcid;
                    Result result = this.processProtocol(pi, lcid, desc, mesg);
                    if (result == null || result == Result.NOT_HANDLED) continue;
                    ret = new MonitorResult(pi, lcid, result.isValid(), result.getReason(), result.getProperties());
                    break;
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.finest("No protocols found for message '" + (Object)((Object)mesg) + "'");
            }
        } else {
            Description desc = this.getProtocolDescription(pid);
            if (cid == null && this.m_conversationResolver != null) {
                cid = this.m_conversationResolver.getConversationId(desc, mesg);
            }
            if (cid != null) {
                messageRelevant = true;
                Result result = this.processProtocol(pid, cid, desc, mesg);
                if (result != null && result != Result.NOT_HANDLED) {
                    ret = new MonitorResult(pid, cid, result.isValid(), result.getReason(), result.getProperties());
                }
            }
        }
        if (ret == null) {
            if (messageRelevant) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Message 'not handled' but relevant: " + (Object)((Object)mesg));
                }
                if (cid == null) {
                    cid = unhandledCID;
                }
                ret = new MonitorResult(pid, cid, false, null, null);
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Message 'not handled' or relevant: " + (Object)((Object)mesg));
            }
        }
        return ret;
    }

    protected Result processProtocol(ProtocolId pid, ConversationId cid, Description desc, Message mesg) {
        Result ret = null;
        if (cid == null) {
            logger.severe("Conversation id not defined for protocol '" + pid + "' and message '" + (Object)((Object)mesg) + "'");
            return Result.INVALID;
        }
        Serializable session = this.m_sessionStore.find(pid, cid);
        boolean f_create = false;
        if (session == null) {
            session = (DefaultSession)this.m_monitor.createSession(this._context, desc, DefaultSession.class);
            f_create = true;
        }
        if (session instanceof Session) {
            ret = mesg.getDirection() == ProtocolCriteria.Direction.Outbound ? this.m_monitor.messageSent(this._context, desc, (Session)session, (org.scribble.protocol.monitor.Message)mesg) : this.m_monitor.messageReceived(this._context, desc, (Session)session, (org.scribble.protocol.monitor.Message)mesg);
            if (ret != Result.NOT_HANDLED) {
                if (f_create) {
                    if (!((Session)session).isFinished()) {
                        this.m_sessionStore.create(pid, cid, session);
                    }
                } else if (((Session)session).isFinished()) {
                    this.m_sessionStore.remove(pid, cid);
                } else {
                    this.m_sessionStore.update(pid, cid, session);
                }
            }
        } else {
            logger.severe("Inappropriate session type returned");
            ret = Result.NOT_HANDLED;
        }
        return ret;
    }

    protected Description getProtocolDescription(ProtocolId pid) {
        Description ret = this.getDescriptionCache().getDescription(pid);
        if (ret == null) {
            try {
                ProtocolModel pm = this.m_protocolRepository.getProtocol(pid);
                CachedJournal journal = new CachedJournal();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                this.m_exporter.export(pm, (Journal)journal, (OutputStream)os);
                os.close();
                if (journal.hasErrors()) {
                    logger.severe("Errors detected when exporting protocol '" + pid + "' to monitorable description");
                } else {
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    ret = MonitorModelUtil.deserialize((InputStream)is);
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to obtain monitorable description for protocol '" + pid + "'", e);
            }
            if (ret != null) {
                this.getDescriptionCache().setDescription(pid, ret);
            }
        }
        return ret;
    }

    protected DescriptionCache getDescriptionCache() {
        return this.m_descriptionCache;
    }

    protected void setDescriptionCache(DescriptionCache dc) {
        this.m_descriptionCache = dc;
    }
}

