/*
 * Decompiled with CFR 0.152.
 */
package org.savara.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.monitor.Message;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.monitor.DefaultMonitorContext;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.MessageNode;
import org.scribble.protocol.monitor.model.MessageType;

public class DefautMonitorContext
extends DefaultMonitorContext {
    private static final Logger LOG = Logger.getLogger(DefautMonitorContext.class.getName());

    public Result validate(Session session, MessageNode mesgNode, org.scribble.protocol.monitor.Message mesg) {
        Result ret = Result.NOT_HANDLED;
        if (mesgNode.getOperator() != null && mesg.getOperator() != null) {
            String op = mesg.getOperator();
            if (mesg instanceof Message && ((Message)mesg).getFault() != null) {
                op = InteractionUtil.getOperator((String)op, (String)((Message)mesg).getFault());
            }
            if (mesgNode.getOperator().equals(op)) {
                ret = Result.VALID;
            }
        }
        if (ret.isValid() && mesgNode.getMessageType().size() > 0) {
            if (mesgNode.getMessageType().size() == mesg.getTypes().size()) {
                ret = Result.VALID;
                for (int i = 0; i < mesgNode.getMessageType().size(); ++i) {
                    MessageType mt = (MessageType)mesgNode.getMessageType().get(i);
                    if (mt.getValue() != null && mt.getValue().equals(mesg.getTypes().get(i))) continue;
                    ret = Result.NOT_HANDLED;
                    break;
                }
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Number of message types different (" + mesgNode.getMessageType().size() + " : " + mesg.getTypes().size() + ")");
                ret = Result.INVALID;
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Session (" + session + ") validate message '" + mesg + "' against node " + mesgNode + " ret = " + ret);
        }
        return ret;
    }
}

