/*
 * Decompiled with CFR 0.152.
 */
package org.savara.monitor;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.savara.common.config.Configuration;
import org.savara.monitor.ConversationId;
import org.savara.monitor.SessionStore;
import org.savara.protocol.ProtocolId;

public class InMemorySessionStore
implements SessionStore {
    private Map<ProtocolId, Map<ConversationId, Serializable>> m_sessions = new HashMap<ProtocolId, Map<ConversationId, Serializable>>();

    public void setConfiguration(Configuration config) {
    }

    protected void addSession(ProtocolId pid, ConversationId cid, Serializable session) {
        Map<ConversationId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions == null) {
            sessions = new HashMap<ConversationId, Serializable>();
            this.m_sessions.put(pid, sessions);
        } else if (sessions.containsKey(cid)) {
            throw new IllegalArgumentException("Conversation instance id already in use");
        }
        sessions.put(cid, session);
    }

    public Serializable create(ProtocolId pid, ConversationId cid, Serializable session) {
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        this.addSession(pid, cid, session);
        return session;
    }

    public Serializable find(ProtocolId pid, ConversationId cid) {
        Serializable ret = null;
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        Map<ConversationId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions != null) {
            ret = sessions.get(cid);
        }
        return ret;
    }

    public void remove(ProtocolId pid, ConversationId cid) {
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        Map<ConversationId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions == null || !sessions.containsKey(cid)) {
            throw new IllegalArgumentException("Conversation instance id is unknown");
        }
        sessions.remove(cid);
        if (sessions.size() == 0) {
            this.m_sessions.remove(pid);
        }
    }

    public void update(ProtocolId pid, ConversationId cid, Serializable session) {
        if (pid == null) {
            throw new IllegalArgumentException("Protocol id not specified");
        }
        if (cid == null) {
            throw new IllegalArgumentException("Conversation instance id not specified");
        }
        Map<ConversationId, Serializable> sessions = this.m_sessions.get(pid);
        if (sessions == null || !sessions.containsKey(cid)) {
            throw new IllegalArgumentException("Conversation instance id unknown");
        }
        sessions.put(cid, session);
    }

    public void close() {
    }
}

