/*
 * Decompiled with CFR 0.152.
 */
package org.savara.protocol.contract.generator.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.logging.MessageFormatter;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.contract.model.Contract;
import org.savara.contract.model.FaultDetails;
import org.savara.contract.model.Interface;
import org.savara.contract.model.MessageExchangePattern;
import org.savara.contract.model.Namespace;
import org.savara.contract.model.OneWayRequestMEP;
import org.savara.contract.model.RequestResponseMEP;
import org.savara.contract.model.Type;
import org.savara.contract.model.TypeDefinition;
import org.savara.protocol.model.util.InteractionUtil;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.ProtocolReference;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Run;
import org.scribble.protocol.model.TypeImport;
import org.scribble.protocol.model.TypeImportList;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.model.Visitor;
import org.scribble.protocol.util.RunUtil;
import org.scribble.protocol.util.TypesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContractIntrospector
extends DefaultVisitor {
    private Contract m_contract = new Contract();
    private Set<Protocol> m_processedProtocols = null;
    private Role m_serverRole = null;
    private Set<Role> m_clientRoles = null;
    private Protocol m_protocol = null;
    private FeedbackHandler m_feedbackHandler = null;
    private static Logger logger = Logger.getLogger(ContractIntrospector.class.getName());

    public ContractIntrospector(Protocol protocol, Set<Role> clients, Role server, FeedbackHandler handler) {
        this(protocol, clients, server, null, null, handler);
    }

    public ContractIntrospector(Protocol protocol, Set<Role> clients, Role server, Contract contract, Set<Protocol> processed, FeedbackHandler handler) {
        this.m_contract = contract;
        this.m_clientRoles = clients;
        this.m_serverRole = server;
        this.m_feedbackHandler = handler;
        if (this.m_contract == null) {
            this.m_contract = new Contract();
            this.m_contract.setName(this.m_serverRole.getName());
            List annotations = AnnotationDefinitions.getAnnotations((List)protocol.getAnnotations(), (String)"Namespace");
            if (annotations != null) {
                for (Annotation annotation : annotations) {
                    String namespace = (String)annotation.getProperties().get("name");
                    String role = (String)annotation.getProperties().get("role");
                    if (namespace == null || role == null || !role.equals(this.m_serverRole.getName())) continue;
                    this.m_contract.setNamespace(namespace);
                    break;
                }
            }
        }
        this.m_processedProtocols = processed != null ? processed : new HashSet<Protocol>();
        this.m_protocol = protocol;
    }

    public Contract getContract() {
        return this.m_contract;
    }

    protected FeedbackHandler getFeedbackHandler() {
        return this.m_feedbackHandler;
    }

    public Interface getInterface(ProtocolModel model, String intfName) {
        QName qname = null;
        qname = intfName == null || intfName.trim().length() == 0 ? new QName(this.m_contract.getNamespace(), this.m_serverRole.getName()) : QName.valueOf(intfName);
        Interface ret = this.getContract().getInterface(qname.getLocalPart());
        if (ret == null) {
            ret = new Interface();
            ret.setName(qname.getLocalPart());
            ret.setNamespace(qname.getNamespaceURI());
            this.addNamespace(model, qname.getNamespaceURI());
            this.getContract().getInterfaces().add(ret);
        }
        return ret;
    }

    public Set<Protocol> getProcessedProtocols() {
        return this.m_processedProtocols;
    }

    public void process() throws IllegalStateException {
        if (this.m_protocol == null) {
            throw new IllegalStateException(MessageFormatter.format((ResourceBundle)PropertyResourceBundle.getBundle("org.savara.contract.Messages"), (String)"SAVARA-CONTRACT-00001", (Object[])new Object[0]));
        }
        this.m_protocol.visit((Visitor)this);
        Iterator iter = this.getContract().getInterfaces().iterator();
        while (iter.hasNext()) {
            Interface intf = (Interface)iter.next();
            if (intf.getMessageExchangePatterns().size() != 0) continue;
            iter.remove();
        }
    }

    public boolean start(Protocol elem) {
        return elem == this.m_protocol;
    }

    public void accept(Run elem) {
        Protocol toProtocol = RunUtil.getInnerProtocol((Protocol)elem.getEnclosingProtocol(), (ProtocolReference)elem.getProtocolReference());
        if (toProtocol != null) {
            if (!this.m_processedProtocols.contains(toProtocol)) {
                this.m_processedProtocols.add(toProtocol);
                Role mappedServerRole = this.m_serverRole;
                Set<Role> mappedClientRoles = this.m_clientRoles;
                ContractIntrospector ci = new ContractIntrospector(toProtocol, mappedClientRoles, mappedServerRole, this.getContract(), this.getProcessedProtocols(), this.getFeedbackHandler());
                ci.process();
            } else {
                logger.fine("Invoked definition not found for " + elem.getProtocolReference());
            }
        } else {
            logger.fine("Run protocol not returned - possibly external");
        }
    }

    protected boolean isRoleRelevant(List<Role> roles) {
        Role role;
        boolean ret = false;
        Iterator<Role> i$ = roles.iterator();
        while (i$.hasNext() && !(ret = this.isRoleRelevant(role = i$.next()))) {
        }
        return ret;
    }

    protected boolean isRoleRelevant(Role role) {
        boolean ret = false;
        ret = role != null && role.equals((Object)this.m_serverRole);
        return ret;
    }

    public void accept(Interaction interaction) {
        MessageExchangePattern mep;
        if (!(this.isRoleRelevant(interaction.getEnclosingProtocol().getLocatedRole()) || this.isRoleRelevant(interaction.getFromRole()) || this.isRoleRelevant(interaction.getToRoles()))) {
            return;
        }
        String intfName = null;
        Annotation intfAnn = AnnotationDefinitions.getAnnotation((List)interaction.getAnnotations(), (String)"Interface");
        if (intfAnn != null) {
            intfName = (String)intfAnn.getProperties().get("name");
        }
        Interface intf = this.getInterface(interaction.getModel(), intfName);
        if (InteractionUtil.isRequest(interaction) && !InteractionUtil.isSend(interaction, this.m_serverRole)) {
            Object mep2;
            if (interaction.getMessageSignature().getOperation() != null && (mep2 = intf.getMessageExchangePatternForOperation(interaction.getMessageSignature().getOperation())) == null) {
                mep2 = InteractionUtil.getRequestLabel(interaction) != null ? new RequestResponseMEP() : new OneWayRequestMEP();
                mep2.setOperation(interaction.getMessageSignature().getOperation());
                for (int i = 0; i < interaction.getMessageSignature().getTypeReferences().size(); ++i) {
                    mep2.getTypes().add(this.convertType((TypeReference)interaction.getMessageSignature().getTypeReferences().get(i)));
                }
                intf.getMessageExchangePatterns().add(mep2);
            }
        } else if (InteractionUtil.isResponse(interaction) && InteractionUtil.isSend(interaction, this.m_serverRole) && interaction.getMessageSignature().getOperation() != null && (mep = intf.getMessageExchangePatternForOperation(interaction.getMessageSignature().getOperation())) instanceof RequestResponseMEP) {
            RequestResponseMEP rrmep = (RequestResponseMEP)mep;
            if (InteractionUtil.isFaultResponse(interaction)) {
                String faultName = InteractionUtil.getFaultName(interaction);
                if (rrmep.getFaultDetails(faultName) == null) {
                    FaultDetails fd = new FaultDetails();
                    fd.setName(faultName);
                    for (int i = 0; i < interaction.getMessageSignature().getTypeReferences().size(); ++i) {
                        fd.getTypes().add(this.convertType((TypeReference)interaction.getMessageSignature().getTypeReferences().get(i)));
                    }
                    rrmep.getFaultDetails().add(fd);
                }
            } else if (rrmep.getResponseTypes().size() == 0) {
                if (interaction.getMessageSignature().getTypeReferences().size() > 1) {
                    this.getFeedbackHandler().error("Response has more than one type", null);
                } else if (interaction.getMessageSignature().getTypeReferences().size() == 1) {
                    rrmep.getResponseTypes().add(this.convertType((TypeReference)interaction.getMessageSignature().getTypeReferences().get(0)));
                }
            }
        }
    }

    public Type convertType(TypeReference tref) {
        Type ret = new Type();
        if (this.getContract().getTypeDefinition(tref.getName()) == null) {
            TypeDefinition td = new TypeDefinition();
            td.setName(tref.getName());
            TypeImport ti = TypesUtil.getTypeImport((TypeReference)tref);
            if (ti != null) {
                TypeImportList til = (TypeImportList)ti.getParent();
                td.setDataType(ti.getDataType().getDetails());
                if (til != null) {
                    for (org.scribble.common.model.Annotation ann : til.getAnnotations()) {
                        if (!(ann instanceof Annotation)) continue;
                        td.getAnnotations().add((Annotation)ann);
                    }
                    td.setTypeSystem(til.getFormat());
                    if (til.getFormat() != null && "xsd".equals(til.getFormat()) && til.getLocation() != null) {
                        this.addNamespace(tref.getModel(), til.getLocation());
                    }
                }
            }
            td.getProperties().putAll(tref.getProperties());
            this.getContract().getTypeDefinitions().add(td);
        }
        ret.setName(tref.getName());
        return ret;
    }

    protected void addNamespace(ProtocolModel model, String namespace) {
        if (this.getContract().getNamespaceForURI(namespace) == null && model != null) {
            List annotations = AnnotationDefinitions.getAnnotations((List)model.getProtocol().getAnnotations(), (String)"Type");
            for (Annotation ann : annotations) {
                String nstxt = (String)ann.getProperties().get("namespace");
                if (nstxt == null || !nstxt.equals(namespace)) continue;
                Namespace ns = new Namespace();
                ns.setURI(namespace);
                ns.setPrefix((String)ann.getProperties().get("prefix"));
                ns.setSchemaLocation((String)ann.getProperties().get("location"));
                this.getContract().getNamespaces().add(ns);
                break;
            }
        }
    }
}

