/*
 * Decompiled with CFR 0.152.
 */
package org.savara.sca.java.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.scribble.protocol.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCAJavaGenerator {
    private static final Logger logger = Logger.getLogger(SCAJavaGenerator.class.getName());

    public static void main(String[] args) {
        SCAJavaGenerator gen = new SCAJavaGenerator();
        try {
            gen.createServiceInterfaceFromWSDL(args[0], args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createServiceInterfaceFromWSDL(String wsdlPath, String wsdlLocation, String srcFolder) throws Exception {
        String[] cxfargs = new String[]{"-d", srcFolder, "-wsdlLocation", wsdlLocation, wsdlPath};
        WSDLToJava wsdlToJava = new WSDLToJava(cxfargs);
        try {
            wsdlToJava.run(new ToolContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate Java interfaces", e);
            throw e;
        }
        this.makeServiceInterfaceRemotable(wsdlPath, srcFolder);
    }

    protected void makeServiceInterfaceRemotable(String wsdlPath, String srcFolder) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        Definition defn = reader.readWSDL(wsdlPath);
        if (defn != null) {
            String pack = this.getJavaPackage(defn.getTargetNamespace());
            String folder = pack.replace('.', File.separatorChar);
            for (PortType portType : defn.getPortTypes().values()) {
                File f = new File(srcFolder + File.separatorChar + folder + File.separatorChar + portType.getQName().getLocalPart() + ".java");
                if (f.exists()) {
                    FileInputStream fis = new FileInputStream(f);
                    byte[] b = new byte[fis.available()];
                    fis.read(b);
                    StringBuffer text = new StringBuffer();
                    text.append(new String(b));
                    fis.close();
                    int index = text.indexOf("public interface");
                    if (index != -1) {
                        text.insert(index, "@org.oasisopen.sca.annotation.Remotable ");
                        FileOutputStream fos = new FileOutputStream(f);
                        fos.write(text.toString().getBytes());
                        fos.close();
                        continue;
                    }
                    logger.severe("Service interface file '" + f.getAbsolutePath() + "' does not have 'public interface' to make remotable");
                    continue;
                }
                logger.severe("Service interface file '" + f.getAbsolutePath() + "' does not exist");
            }
        } else {
            logger.severe("Failed to retrieve WSDL definition '" + wsdlPath + "'");
        }
    }

    protected String getJavaPackage(String namespace) {
        String ret = null;
        try {
            int index;
            URI uri = new URI(namespace);
            String host = uri.getHost();
            if (host.startsWith("www.")) {
                host = host.substring(4);
            }
            if ((index = host.lastIndexOf(46)) != -1) {
                ret = host.substring(index + 1);
                ret = ret + "." + host.substring(0, index);
            } else {
                ret = host;
            }
            ret = ret + uri.getPath().replace('/', '.');
            ret = ret.toLowerCase();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get java package from namespace '" + namespace + "'", e);
        }
        return ret;
    }

    public void createServiceImplementationFromWSDL(Role role, List<Role> refRoles, String wsdlPath, String wsdlLocation, List<String> refWsdlPaths, String srcFolder) throws Exception {
        String[] cxfargs = new String[]{"-impl", "-d", srcFolder, "-wsdlLocation", wsdlLocation, wsdlPath};
        WSDLToJava wsdlToJava = new WSDLToJava(cxfargs);
        try {
            wsdlToJava.run(new ToolContext());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to generate Java interfaces", e);
            throw e;
        }
        this.makeServiceInterfaceRemotable(wsdlPath, srcFolder);
        this.addServiceReferencesToImplementation(role, refRoles, wsdlPath, refWsdlPaths, srcFolder);
    }

    protected void addServiceReferencesToImplementation(Role role, List<Role> refRoles, String wsdlPath, List<String> refWsdlPaths, String srcFolder) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        if (refRoles.size() != refWsdlPaths.size()) {
            throw new IllegalArgumentException("The number of reference roles and wsdl paths are not consistent");
        }
        Definition defn = reader.readWSDL(wsdlPath);
        if (defn != null) {
            String pack = this.getJavaPackage(defn.getTargetNamespace());
            String folder = pack.replace('.', File.separatorChar);
            for (PortType portType : defn.getPortTypes().values()) {
                File f = new File(srcFolder + File.separatorChar + folder + File.separatorChar + portType.getQName().getLocalPart() + "Impl.java");
                if (f.exists()) {
                    FileInputStream fis = new FileInputStream(f);
                    byte[] b = new byte[fis.available()];
                    fis.read(b);
                    StringBuffer text = new StringBuffer();
                    text.append(new String(b));
                    fis.close();
                    int index = text.indexOf("private static final Logger");
                    if (index != -1) {
                        for (int i = 0; i < refRoles.size(); ++i) {
                            Definition refDefn = reader.readWSDL(refWsdlPaths.get(i));
                            if (refDefn == null) continue;
                            String refPack = this.getJavaPackage(refDefn.getTargetNamespace());
                            Iterator refPortTypes = refDefn.getPortTypes().values().iterator();
                            int refPortCount = 1;
                            while (refPortTypes.hasNext()) {
                                PortType refPortType = (PortType)refPortTypes.next();
                                String name = Character.toLowerCase(refRoles.get(i).getName().charAt(0)) + refRoles.get(i).getName().substring(1);
                                if (refDefn.getPortTypes().size() > 1) {
                                    name = name + refPortCount;
                                }
                                text.insert(index, "@org.oasisopen.sca.annotation.Reference\r\n    " + refPack + "." + refPortType.getQName().getLocalPart() + " " + name + ";\r\n\r\n    ");
                            }
                        }
                        FileOutputStream fos = new FileOutputStream(f);
                        fos.write(text.toString().getBytes());
                        fos.close();
                        continue;
                    }
                    logger.severe("Service implementation file '" + f.getAbsolutePath() + "' does not have 'private static final Logger' as location to insert references");
                    continue;
                }
                logger.severe("Service implementation file '" + f.getAbsolutePath() + "' does not exist");
            }
        } else {
            logger.severe("Failed to retrieve WSDL definition '" + wsdlPath + "'");
        }
    }

    public void createServiceComposite(Role role, List<Role> refRoles, String wsdlPath, List<String> refWsdlPaths, String resourceFolder) throws Exception {
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        Definition defn = reader.readWSDL(wsdlPath);
        if (defn != null) {
            String pack = this.getJavaPackage(defn.getTargetNamespace());
            StringBuffer composite = new StringBuffer();
            composite.append("<composite xmlns=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\"\r\n");
            composite.append("\t\txmlns:tuscany=\"http://tuscany.apache.org/xmlns/sca/1.1\"\r\n");
            composite.append("\t\ttargetNamespace=\"");
            composite.append(defn.getTargetNamespace());
            composite.append("\"\r\n\t\tname=\"");
            composite.append(role.getName());
            composite.append("\" >\r\n");
            for (PortType portType : defn.getPortTypes().values()) {
                composite.append("\t<component name=\"" + portType.getQName().getLocalPart() + "Component\">\r\n");
                composite.append("\t\t<implementation.java class=\"" + pack + "." + portType.getQName().getLocalPart() + "Impl\" />\r\n");
                composite.append("\t\t<service name=\"" + portType.getQName().getLocalPart() + "\">\r\n");
                composite.append("\t\t\t<interface.java interface=\"" + pack + "." + portType.getQName().getLocalPart() + "\" />\r\n");
                composite.append("\t\t\t<binding.ws uri=\"http://localhost:8080/" + portType.getQName().getLocalPart() + "Component\" />\r\n");
                composite.append("\t\t</service>\r\n");
                for (int i = 0; i < refWsdlPaths.size(); ++i) {
                    String refWsdlPath = refWsdlPaths.get(i);
                    Definition refDefn = reader.readWSDL(refWsdlPath);
                    if (refDefn == null) continue;
                    Iterator refPortTypes = refDefn.getPortTypes().values().iterator();
                    int refPortCount = 1;
                    while (refPortTypes.hasNext()) {
                        PortType refPortType = (PortType)refPortTypes.next();
                        String name = Character.toLowerCase(refRoles.get(i).getName().charAt(0)) + refRoles.get(i).getName().substring(1);
                        if (refDefn.getPortTypes().size() > 1) {
                            name = name + refPortCount;
                        }
                        composite.append("\t\t<reference name=\"" + name + "\">\r\n");
                        composite.append("\t\t\t<binding.ws uri=\"http://localhost:8080/" + refPortType.getQName().getLocalPart() + "Component\" />\r\n");
                        composite.append("\t\t</reference>\r\n");
                        ++refPortCount;
                    }
                }
                composite.append("\t</component>\r\n");
            }
            composite.append("</composite>\r\n");
            FileOutputStream fos = new FileOutputStream(resourceFolder + File.separatorChar + role.getName() + ".composite");
            fos.write(composite.toString().getBytes());
            fos.close();
        }
    }
}

