/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.sca;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.core.invocation.impl.MessageImpl;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.node.Contribution;
import org.apache.tuscany.sca.node.Node;
import org.apache.tuscany.sca.node.NodeFactory;
import org.savara.common.resources.ResourceLocator;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;
import org.savara.scenario.simulation.SimulationModel;
import org.savara.scenario.simulator.sca.internal.MessageStore;
import org.savara.scenario.simulator.sca.internal.ReferenceInvoker;
import org.savara.scenario.simulator.sca.internal.ServiceInvoker;
import org.savara.scenario.simulator.sca.internal.ServiceStore;
import org.savara.scenario.simulator.sca.internal.binding.ws.runtime.WSBindingProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCARoleSimulator
implements RoleSimulator {
    private static final String SCA_SIMULATOR = "SCA simulator";
    private static final String SCA_COMPOSITE_FILE_EXTENSION = ".composite";
    private int m_eventCounter = 0;
    private ServiceStore m_serviceStore = null;
    private MessageStore m_messageStore = null;
    private SimulationContext m_context = null;
    private static final Logger logger = Logger.getLogger(SCARoleSimulator.class.getName());

    public String getName() {
        return SCA_SIMULATOR;
    }

    public void initialize(SimulationContext context) throws Exception {
        this.m_context = context;
        if (this.m_messageStore != null) {
            this.m_messageStore.setSimulationContext(context);
        }
    }

    public boolean isSupported(SimulationModel model) {
        return model.getName().endsWith(SCA_COMPOSITE_FILE_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getModel(SimulationModel model, ResourceLocator locator) {
        Node ret = null;
        if (model.getName().endsWith(SCA_COMPOSITE_FILE_EXTENSION)) {
            try {
                SCARoleSimulator sCARoleSimulator = this;
                synchronized (sCARoleSimulator) {
                    this.m_serviceStore = new ServiceStore();
                    this.m_messageStore = new MessageStore();
                    if (this.m_context != null) {
                        this.m_messageStore.setSimulationContext(this.m_context);
                    }
                    WSBindingProviderFactory.setServiceStore(this.m_serviceStore);
                    WSBindingProviderFactory.setMessageStore(this.m_messageStore);
                    NodeFactory nf = NodeFactory.newInstance();
                    String modelPath = this.getModelPath(model.getName());
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Loading SCA composite for '" + model.getName() + "' from: " + modelPath);
                    }
                    Node n = nf.createNode(modelPath, new Contribution[0]);
                    ret = n.start();
                    WSBindingProviderFactory.setServiceStore(null);
                    WSBindingProviderFactory.setMessageStore(null);
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Failed to load SCA composite model", e);
            }
        }
        return ret;
    }

    protected String getModelPath(String name) {
        String ret = name;
        File f = new File(name);
        if (f.isAbsolute() && f.isFile()) {
            File top = f;
            String path = null;
            do {
                File cur = f;
                do {
                    path = path == null ? cur.getName() : cur.getName() + File.separator + path;
                } while (cur != f);
                if (path == null || ClassLoader.getSystemResource(path) != null) continue;
                path = null;
            } while ((top = top.getParentFile()) != null && path == null);
            if (path != null) {
                ret = path;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("GetModelPath fullpath=" + f.getAbsolutePath() + " ret=" + ret);
        }
        return ret;
    }

    public List<Role> getModelRoles(Object model) {
        return Collections.emptyList();
    }

    public Object getModelForRole(Object model, Role role, ResourceLocator locator) {
        return null;
    }

    public void onEvent(SimulationContext context, final Event event, final SimulationHandler handler) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("onEvent " + event);
        }
        if (event instanceof ReceiveEvent) {
            ReceiveEvent recv = (ReceiveEvent)event;
            boolean handled = false;
            this.incrementEventCounter();
            Collection<ServiceInvoker> invokers = this.m_serviceStore.getServices();
            for (final ServiceInvoker invoker : invokers) {
                String opName = recv.getOperationName();
                Operation operation = null;
                for (InvocationChain invocationChain : invoker.getEndpoint().getInvocationChains()) {
                    if (!opName.equals(invocationChain.getSourceOperation().getName())) continue;
                    operation = invocationChain.getSourceOperation();
                    break;
                }
                if (operation == null) continue;
                final MessageImpl msg = new MessageImpl();
                msg.setOperation(operation);
                try {
                    msg.setBody((Object)this.getRequestBody(operation, recv.getParameter()));
                    new Thread(new Runnable(){

                        public void run() {
                            handler.processed(event);
                            try {
                                Message resp = invoker.invoke((Message)msg);
                                if (resp != null) {
                                    SCARoleSimulator.this.m_messageStore.waitForSendEvent(resp);
                                }
                            }
                            catch (Throwable t) {
                                handler.error("Failed to handle receive event", event, t);
                                t.printStackTrace();
                            }
                            SCARoleSimulator.this.decrementEventCounter();
                        }
                    }).start();
                    handled = true;
                }
                catch (Exception e) {
                    handler.error("Failed to create request message", event, (Throwable)e);
                }
                break;
            }
            if (!handled) {
                Collection<ReferenceInvoker> refInvokers = this.m_serviceStore.getReferences();
                for (ReferenceInvoker refInvoker : refInvokers) {
                    String opName = recv.getOperationName();
                    Operation operation = null;
                    for (Operation op : refInvoker.getEndpointReference().getComponentReferenceInterfaceContract().getInterface().getOperations()) {
                        if (!opName.equals(op.getName())) continue;
                        operation = op;
                        break;
                    }
                    if (operation == null) continue;
                    try {
                        this.m_messageStore.handleReceiveEvent(recv, handler);
                    }
                    catch (Throwable t) {
                        handler.error("Failed to handle receive event", event, t);
                    }
                    this.decrementEventCounter();
                    handled = true;
                    break;
                }
                if (!handled) {
                    handler.unexpected(event);
                    this.decrementEventCounter();
                }
            }
        } else if (event instanceof SendEvent) {
            SendEvent send = (SendEvent)event;
            this.incrementEventCounter();
            try {
                this.m_messageStore.handleSendEvent(send, handler);
            }
            catch (Throwable t) {
                handler.error("Failed to handle send event", event, t);
            }
            this.decrementEventCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementEventCounter() {
        SCARoleSimulator sCARoleSimulator = this;
        synchronized (sCARoleSimulator) {
            ++this.m_eventCounter;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Increment event counter: " + this.m_eventCounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementEventCounter() {
        SCARoleSimulator sCARoleSimulator = this;
        synchronized (sCARoleSimulator) {
            --this.m_eventCounter;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Decrement event counter: " + this.m_eventCounter);
            }
            this.notifyAll();
        }
    }

    protected Object[] getRequestBody(Operation op, List<Parameter> parameters) throws Exception {
        Object[] ret = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            InputStream is = this.m_context.getResource(parameters.get(i).getValue());
            byte[] b = new byte[is.available()];
            is.read(b);
            ret[i] = MessageStore.transformRequestStringToJAXBValue(new String(b), op, (DataType)((List)op.getInputType().getLogical()).get(i));
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Request parameter body " + i + " = " + ret[i]);
            }
            is.close();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SimulationContext context) throws Exception {
        SCARoleSimulator sCARoleSimulator = this;
        synchronized (sCARoleSimulator) {
            while (this.m_eventCounter > 0) {
                this.wait(5000L);
            }
        }
        if (context.getModel() instanceof Node) {
            ((Node)context.getModel()).stop();
        }
    }
}

