/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.sca.internal;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.WebFault;
import org.apache.tuscany.sca.core.invocation.impl.MessageImpl;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.impl.TransformationContextImpl;
import org.apache.tuscany.sca.databinding.jaxb.JAXB2Node;
import org.apache.tuscany.sca.databinding.jaxb.String2JAXB;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Message;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.MessageEvent;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;
import org.savara.scenario.simulator.sca.internal.binding.ws.runtime.WSBindingProviderFactory;
import org.savara.scenario.util.MessageUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStore {
    private static final Logger logger = Logger.getLogger(MessageStore.class.getName());
    private List<ReceiveEvent> m_receiveEvents = new Vector<ReceiveEvent>();
    private SynchronousQueue<SendEvent> m_sendEvents = new SynchronousQueue();
    private SimulationHandler m_handler = null;
    private SimulationContext m_context = null;

    public void setSimulationContext(SimulationContext context) {
        this.m_context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSendEvent(Message mesg) throws Exception {
        SendEvent send = this.m_sendEvents.take();
        if (this.isValidMessage((MessageEvent)send, mesg)) {
            this.m_handler.processed((Event)send);
        } else {
            this.m_handler.unexpected((Event)send);
        }
        SendEvent sendEvent = send;
        synchronized (sendEvent) {
            send.notifyAll();
        }
    }

    protected String getValue(String path) {
        String ret = null;
        try {
            InputStream is = this.m_context.getResource(path);
            byte[] b = new byte[is.available()];
            is.read(b);
            ret = new String(b);
            is.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get parameter value '" + path + "'", e);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Get value = " + ret);
        }
        return ret;
    }

    protected boolean isValidMessage(MessageEvent event, Message mesg) {
        boolean ret = false;
        if (event.getOperationName().equals(mesg.getOperation().getName())) {
            if (mesg.getBody() instanceof Object[]) {
                Object[] params = (Object[])mesg.getBody();
                if (event.getParameter().size() == params.length) {
                    ret = true;
                    for (int i = 0; ret && i < event.getParameter().size(); ++i) {
                        DataType dtypes = mesg.getOperation().getInputType();
                        ret = this.isValidParameter((Parameter)event.getParameter().get(i), MessageStore.transformJAXBToNodeValue(params[i], mesg.getOperation(), (DataType)((List)dtypes.getLogical()).get(i)));
                    }
                }
            } else if (event.getParameter().size() == 1) {
                DataType dtype = null;
                Object content = mesg.getBody();
                if (mesg.isFault()) {
                    List dtypes = mesg.getOperation().getFaultTypes();
                    for (DataType dt : dtypes) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Checking fault body '" + mesg.getBody().getClass() + "' against data type '" + dt.getPhysical() + "'");
                        }
                        if (mesg.getBody().getClass() != dt.getPhysical()) continue;
                        dtype = dt;
                        break;
                    }
                    if (dtype.getDataBinding() == null && dtype.getLogical() instanceof DataType) {
                        dtype = (DataType)dtype.getLogical();
                        try {
                            for (int i = 0; i < content.getClass().getMethods().length; ++i) {
                                Method method = content.getClass().getMethods()[i];
                                if (!method.getReturnType().getName().equals(dtype.getPhysical().getName()) || method.getParameterTypes().length != 0) continue;
                                content = method.invoke(content, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to extract fault content from exception", e);
                        }
                    }
                    if (dtype == null) {
                        logger.severe("Cannot find data type for fault body '" + mesg.getBody().getClass() + "'");
                    } else if (content == null) {
                        logger.severe("Cannot find content for fault body '" + mesg.getBody() + "'");
                    }
                } else {
                    List dtypes = (List)mesg.getOperation().getOutputType().getLogical();
                    if (dtypes.size() > 0) {
                        dtype = (DataType)dtypes.get(0);
                    }
                }
                ret = this.isValidParameter((Parameter)event.getParameter().get(0), MessageStore.transformJAXBToNodeValue(content, mesg.getOperation(), dtype));
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Is message " + mesg + " valid against event " + event + "? = " + ret);
        }
        return ret;
    }

    public static Object transformJAXBToNodeValue(Object source, Operation op, DataType<?> dtype) {
        Object ret = source;
        if (dtype != null && !(source instanceof String) && !(source instanceof Node)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transform " + source + " of type " + dtype);
            }
            JAXB2Node transformer = new JAXB2Node(WSBindingProviderFactory.getRegistry());
            TransformationContextImpl context = new TransformationContextImpl();
            context.setSourceDataType(dtype);
            context.setSourceOperation(op);
            ret = transformer.transform(source, (TransformationContext)context);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transformed into " + ret);
            }
        }
        return ret;
    }

    public static Object transformRequestStringToJAXBValue(Object source, Operation op, DataType<?> dtype) {
        Object ret = source;
        if (source instanceof String && dtype.getPhysical() != String.class) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transform " + source + " of type " + dtype);
            }
            String2JAXB transformer = new String2JAXB(WSBindingProviderFactory.getRegistry());
            TransformationContextImpl context = new TransformationContextImpl();
            context.setTargetDataType(dtype);
            context.setTargetOperation(op);
            ret = transformer.transform((String)source, (TransformationContext)context);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transformed into " + ret);
            }
        }
        return ret;
    }

    public static Object transformResponseStringToJAXBValue(Object source, Operation op, DataType<?> dtype) {
        Object ret = source;
        if (dtype != null && source instanceof String && dtype.getPhysical() != String.class) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transform " + source + " of type " + dtype);
            }
            String2JAXB transformer = new String2JAXB(WSBindingProviderFactory.getRegistry());
            TransformationContextImpl context = new TransformationContextImpl();
            context.setTargetDataType(dtype);
            context.setTargetOperation(op);
            ret = transformer.transform((String)source, (TransformationContext)context);
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Transformed into " + ret);
            }
        }
        return ret;
    }

    protected boolean isValidParameter(Parameter param, Object value) {
        boolean ret = false;
        String paramValue = this.getValue(param.getValue());
        if (paramValue != null && MessageUtil.isValid((String)paramValue, (Object)value)) {
            ret = true;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Is valid parameter '" + param.getValue() + ":" + paramValue + "' = '" + value + "'? " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSendEvent(SendEvent send, SimulationHandler handler) throws Exception {
        this.m_handler = handler;
        SendEvent sendEvent = send;
        synchronized (sendEvent) {
            this.m_sendEvents.offer(send, 5000L, TimeUnit.MILLISECONDS);
            send.wait(20000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReceiveEvent(ReceiveEvent receive, SimulationHandler handler) throws Exception {
        this.m_handler = handler;
        ReceiveEvent receiveEvent = receive;
        synchronized (receiveEvent) {
            this.m_receiveEvents.add(receive);
            List<ReceiveEvent> list = this.m_receiveEvents;
            synchronized (list) {
                this.m_receiveEvents.notifyAll();
            }
            receive.wait(20000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message waitForReceiveEvent(Operation operation) throws Exception {
        MessageImpl ret = null;
        List<ReceiveEvent> list = this.m_receiveEvents;
        synchronized (list) {
            boolean f_found = false;
            long endtime = System.currentTimeMillis() + 5000L;
            do {
                for (ReceiveEvent receive : this.m_receiveEvents) {
                    if (!receive.getOperationName().equals(operation.getName())) continue;
                    f_found = true;
                    MessageImpl resp = new MessageImpl();
                    resp.setOperation(operation);
                    DataType dtype = null;
                    DataType<?> excDType = null;
                    if (receive.getFaultName() != null && receive.getFaultName().trim().length() > 0) {
                        excDType = MessageStore.getDataTypeForFaultName(operation, receive.getFaultName());
                        dtype = (DataType)excDType.getLogical();
                    } else if (((List)operation.getOutputType().getLogical()).size() > 0) {
                        dtype = (DataType)((List)operation.getOutputType().getLogical()).get(0);
                    }
                    Object value = MessageStore.transformResponseStringToJAXBValue(this.getValue(((Parameter)receive.getParameter().get(0)).getValue()), operation, dtype);
                    this.m_receiveEvents.remove(receive);
                    this.m_handler.processed((Event)receive);
                    ReceiveEvent receiveEvent = receive;
                    synchronized (receiveEvent) {
                        receive.notifyAll();
                    }
                    if (excDType != null) {
                        Constructor con = excDType.getPhysical().getConstructor(String.class, dtype.getPhysical());
                        resp.setFaultBody(con.newInstance(receive.getFaultName(), value));
                        ret = resp;
                        break;
                    }
                    resp.setBody(value);
                    ret = resp;
                    break;
                }
                if (f_found) continue;
                long delay = endtime - System.currentTimeMillis();
                if (delay <= 0L) {
                    f_found = true;
                    continue;
                }
                this.m_receiveEvents.wait(delay);
            } while (!f_found);
        }
        return ret;
    }

    public static DataType<?> getDataTypeForFaultName(Operation operation, String faultName) {
        DataType ret = null;
        for (DataType faultDataType : operation.getFaultTypes()) {
            WebFault wf = faultDataType.getPhysical().getAnnotation(WebFault.class);
            if (wf == null || wf.name() == null || !wf.name().equals(faultName)) continue;
            ret = faultDataType;
            break;
        }
        return ret;
    }
}

