/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.xml.namespace.QName;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.savara.common.resources.ResourceLocator;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;
import org.savara.scenario.simulation.SimulationModel;
import org.savara.scenario.simulator.switchyard.binding.soap.OutboundHandler;
import org.savara.scenario.simulator.switchyard.binding.soap.deploy.SOAPActivator;
import org.savara.scenario.simulator.switchyard.internal.MessageStore;
import org.switchyard.deploy.Activator;
import org.switchyard.standalone.SwitchYard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchyardRoleSimulator
implements RoleSimulator {
    private static final String BINDING_CONTEXT = "java:comp";
    private static final String BEAN_MANAGER_NAME = "BeanManager";
    private static final String SWITCHYARD_SIMULATOR = "Switchyard simulator";
    private static final String SWITCHYARD_DESCRIPTOR = "switchyard.xml";
    private SimulationContext _context = null;
    private SwitchYard _switchyard = null;
    private SOAPActivator _activator = null;
    private MessageStore _messageStore = new MessageStore();
    private int _eventCounter = 0;
    private static final Logger LOG = Logger.getLogger(SwitchyardRoleSimulator.class.getName());

    public String getName() {
        return SWITCHYARD_SIMULATOR;
    }

    public void initialize(SimulationContext context) throws Exception {
        this._context = context;
        if (this._messageStore != null) {
            this._messageStore.setSimulationContext(context);
        }
        if (context.getModel() instanceof File) {
            FileInputStream is = new FileInputStream((File)context.getModel());
            this._switchyard = new SwitchYard((InputStream)is);
            ((InputStream)is).close();
            System.getProperties().put("java.naming.factory.initial", JNDIFactory.class.getName());
            this._switchyard.start();
            for (Activator activator : this._switchyard.getActivatorList()) {
                if (!(activator instanceof SOAPActivator)) continue;
                this._activator = (SOAPActivator)activator;
                for (OutboundHandler oh : this._activator.getOutboundHandlers().values()) {
                    oh.setMessageStore(this._messageStore);
                }
            }
        }
    }

    protected SOAPActivator getActivator() {
        return this._activator;
    }

    public boolean isSupported(SimulationModel model) {
        return model.getName().endsWith(SWITCHYARD_DESCRIPTOR);
    }

    public Object getModel(SimulationModel model, ResourceLocator locator) {
        File ret = null;
        if (model.getName().endsWith(SWITCHYARD_DESCRIPTOR)) {
            try {
                ret = new File(model.getName());
                if (!ret.exists()) {
                    ret = null;
                    URL url = Thread.currentThread().getContextClassLoader().getResource(model.getName());
                    if (url != null && !(ret = new File(url.getFile())).exists()) {
                        ret = null;
                    }
                }
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Failed to load Switchyard descriptor model", e);
            }
        }
        return ret;
    }

    public List<Role> getModelRoles(Object model) {
        return Collections.emptyList();
    }

    public Object getModelForRole(Object model, Role role, ResourceLocator locator) {
        return null;
    }

    public void onEvent(SimulationContext context, Event event, final SimulationHandler handler) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("onEvent " + event);
        }
        this._messageStore.setHandler(handler);
        if (event instanceof ReceiveEvent) {
            final ReceiveEvent recv = (ReceiveEvent)event;
            this.incrementEventCounter();
            if (this._activator.getInboundHandler().isOperation(recv.getOperationName())) {
                LOG.fine("Invoke REQUEST: " + recv);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            InputStream is = SwitchyardRoleSimulator.this._context.getResource(((Parameter)recv.getParameter().get(0)).getValue());
                            byte[] b = new byte[is.available()];
                            is.read(b);
                            is.close();
                            handler.processed((Event)recv);
                            String resp = SwitchyardRoleSimulator.this._activator.getInboundHandler().invoke(recv.getOperationName(), new String(b), QName.valueOf(((Parameter)recv.getParameter().get(0)).getType()));
                            if (resp != null) {
                                SwitchyardRoleSimulator.this._messageStore.waitForSendEvent(recv.getOperationName(), resp);
                            }
                        }
                        catch (Throwable t) {
                            LOG.log(Level.SEVERE, "Failed to invoke service", t);
                        }
                        SwitchyardRoleSimulator.this.decrementEventCounter();
                    }
                });
                t.start();
            } else {
                LOG.fine("Receive RESPONSE: " + recv);
                try {
                    this._messageStore.handleReceiveEvent(recv);
                }
                catch (Throwable t) {
                    handler.error("Failed to handle receive event", event, t);
                }
                this.decrementEventCounter();
            }
        } else if (event instanceof SendEvent) {
            SendEvent send = (SendEvent)event;
            this.incrementEventCounter();
            try {
                this._messageStore.handleSendEvent(send);
            }
            catch (Throwable t) {
                handler.error("Failed to handle send event", event, t);
            }
            this.decrementEventCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementEventCounter() {
        SwitchyardRoleSimulator switchyardRoleSimulator = this;
        synchronized (switchyardRoleSimulator) {
            ++this._eventCounter;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Increment event counter: " + this._eventCounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementEventCounter() {
        SwitchyardRoleSimulator switchyardRoleSimulator = this;
        synchronized (switchyardRoleSimulator) {
            --this._eventCounter;
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Decrement event counter: " + this._eventCounter);
            }
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(SimulationContext context) throws Exception {
        SwitchyardRoleSimulator switchyardRoleSimulator = this;
        synchronized (switchyardRoleSimulator) {
            while (this._eventCounter > 0) {
                this.wait(5000L);
            }
        }
        if (this._messageStore != null) {
            this._messageStore.close();
        }
        if (this._switchyard != null) {
            this._switchyard.stop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JNDIContext
    implements Context {
        Map<String, Object> _contents = new HashMap<String, Object>();
        private static Weld _weld = new Weld();
        private static WeldContainer _weldContainer = _weld.initialize();

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.lookup(name.toString());
        }

        @Override
        public Object lookup(String name) throws NamingException {
            if (!this._contents.containsKey(name)) {
                if (name.equals(SwitchyardRoleSimulator.BINDING_CONTEXT)) {
                    return this;
                }
                if (name.equals(SwitchyardRoleSimulator.BEAN_MANAGER_NAME)) {
                    return _weldContainer.getBeanManager();
                }
                throw new NamingException("Item '" + name + "' not found");
            }
            return this._contents.get(name);
        }

        @Override
        public void bind(Name name, Object obj) throws NamingException {
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
        }

        @Override
        public void rebind(Name name, Object obj) throws NamingException {
        }

        @Override
        public void rebind(String name, Object obj) throws NamingException {
        }

        @Override
        public void unbind(Name name) throws NamingException {
        }

        @Override
        public void unbind(String name) throws NamingException {
        }

        @Override
        public void rename(Name oldName, Name newName) throws NamingException {
        }

        @Override
        public void rename(String oldName, String newName) throws NamingException {
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            return null;
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return null;
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            return null;
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return null;
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            return null;
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return null;
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            return null;
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            return null;
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            return null;
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            return null;
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            return null;
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return null;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return null;
        }

        static {
            _weldContainer.event().select(ContainerInitialized.class, new Annotation[0]).fire((Object)new ContainerInitialized());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JNDIFactory
    implements InitialContextFactory {
        @Override
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            return new JNDIContext();
        }
    }
}

