/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard.binding.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.savara.common.util.XMLUtils;
import org.savara.scenario.simulator.switchyard.binding.soap.PortName;
import org.savara.scenario.simulator.switchyard.binding.soap.config.model.SOAPBindingModel;
import org.savara.scenario.simulator.switchyard.binding.soap.util.WSDLUtil;
import org.switchyard.Exchange;
import org.switchyard.ExchangeHandler;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceReference;
import org.switchyard.component.common.DeliveryException;
import org.switchyard.component.common.SynchronousInOutHandler;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.transform.Transformer;
import org.w3c.dom.Node;

public class InboundHandler
extends BaseServiceHandler {
    private static final Logger LOG = Logger.getLogger(InboundHandler.class.getName());
    private final SOAPBindingModel _config;
    private ServiceDomain _domain;
    private ServiceReference _service;
    private Port _wsdlPort;

    public InboundHandler(SOAPBindingModel config, ServiceDomain domain) {
        this._config = config;
        this._domain = domain;
    }

    public void start() {
        this._service = this._domain.getServiceReference(this._config.getServiceName());
        PortName portName = this._config.getPort();
        String wsdlLocation = this._config.getWsdl();
        try {
            Service wsdlService = WSDLUtil.getService(wsdlLocation, portName);
            this._wsdlPort = WSDLUtil.getPort(wsdlService, portName);
        }
        catch (Exception e) {
            LOG.severe("Failed to get WSDL: wsdl=" + wsdlLocation);
        }
    }

    public void handleFault(Exchange exchange) {
        throw new IllegalStateException("Unexpected");
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        throw new IllegalStateException("Unexpected");
    }

    public boolean isOperation(String op) {
        return WSDLUtil.getOperationByName(this._wsdlPort, op) != null;
    }

    public String invoke(String operation, String mesg, QName type) {
        block10: {
            try {
                SynchronousInOutHandler inOutHandler = new SynchronousInOutHandler();
                Exchange exchange = this._service.createExchange(operation, (ExchangeHandler)inOutHandler);
                Message req = exchange.createMessage();
                Node bodyNode = XMLUtils.getNode((String)mesg);
                req.setContent((Object)new DOMSource(bodyNode));
                exchange.send(req);
                Operation op = WSDLUtil.getOperationByName(this._wsdlPort, operation);
                if (WSDLUtil.isOneWay(op)) break block10;
                try {
                    exchange = inOutHandler.waitForOut(12000L);
                }
                catch (DeliveryException e) {
                    e.printStackTrace();
                }
                Message resp = exchange.getMessage();
                if (resp == null) {
                    LOG.severe("No response received");
                    break block10;
                }
                if (resp.getContent() instanceof Exception) {
                    for (Object obj : op.getFaults().values()) {
                        Fault fault = (Fault)obj;
                        QName qname = ((Part)fault.getMessage().getParts().values().iterator().next()).getElementName();
                        QName from = new QName("java:" + resp.getContent().getClass().getName());
                        try {
                            Transformer transformer = this._domain.getTransformerRegistry().getTransformer(from, qname);
                            if (transformer == null) continue;
                            Object result = transformer.transform(resp.getContent());
                            if (result instanceof String) {
                                return (String)result;
                            }
                            LOG.severe("Expecting a string, but got: " + result);
                        }
                        catch (Exception e) {}
                    }
                    throw (Exception)resp.getContent();
                }
                return (String)resp.getContent(String.class);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to invoke", e);
            }
        }
        return null;
    }
}

