/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard.binding.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.savara.common.util.XMLUtils;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.simulator.switchyard.binding.soap.config.model.SOAPBindingModel;
import org.savara.scenario.simulator.switchyard.internal.MessageStore;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.deploy.BaseServiceHandler;
import org.w3c.dom.Node;

public class OutboundHandler
extends BaseServiceHandler {
    private static final Logger LOG = Logger.getLogger(OutboundHandler.class.getName());
    private MessageStore _messageStore = null;
    private SOAPBindingModel _config = null;

    public OutboundHandler(SOAPBindingModel config) {
        this._config = config;
    }

    public SOAPBindingModel getConfig() {
        return this._config;
    }

    public void setMessageStore(MessageStore ms) {
        this._messageStore = ms;
    }

    public void start() {
    }

    public void stop() {
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        block7: {
            String content = (String)exchange.getMessage().getContent(String.class);
            String op = exchange.getContract().getProviderOperation().getName();
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.fine("Handle outbound message: " + content);
            }
            try {
                this._messageStore.waitForSendEvent(op, content);
                if (exchange.getContract().getProviderOperation().getExchangePattern() != ExchangePattern.IN_OUT) break block7;
                ReceiveEvent respEvent = this._messageStore.waitForReceiveEvent(op);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.fine("Response receive event: " + respEvent);
                }
                Message respMessage = exchange.createMessage();
                if (respEvent != null) {
                    String resp = this._messageStore.getMessageContent(((Parameter)respEvent.getParameter().get(0)).getValue());
                    Node bodyNode = XMLUtils.getNode((String)resp);
                    respMessage.setContent((Object)new DOMSource(bodyNode));
                    if (respEvent.getFaultName() != null && respEvent.getFaultName().trim().length() > 0) {
                        exchange.sendFault(respMessage);
                    } else {
                        exchange.send(respMessage);
                    }
                    break block7;
                }
                throw new HandlerException("Expected response, but got no receive event");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

