/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard.binding.soap;

import java.io.Serializable;
import javax.xml.namespace.QName;

public class PortName
implements Serializable {
    private static final long serialVersionUID = -1904811344687200683L;
    private QName _serviceQName = new QName("");
    private String _name;

    public PortName() {
    }

    public PortName(String portName) {
        if (portName != null) {
            int idx = portName.lastIndexOf(":");
            this._name = portName.substring(idx + 1, portName.length());
            if (idx > 0) {
                String serviceStr = portName.substring(0, idx);
                this._serviceQName = QName.valueOf(serviceStr);
            }
        }
    }

    public PortName(QName serviceQName, String name) {
        if (serviceQName != null) {
            this._serviceQName = serviceQName;
        }
        this._name = name;
    }

    public PortName(String namespace, String serviceName, String name) {
        this._serviceQName = new QName(namespace, serviceName);
        this._name = name;
    }

    public QName getPortQName() {
        return new QName(this.getNamespaceURI(), this._name);
    }

    public QName getServiceQName() {
        return this._serviceQName;
    }

    public void setServiceQName(QName serviceQName) {
        this._serviceQName = serviceQName;
    }

    public String getServiceName() {
        return this._serviceQName.getLocalPart();
    }

    public void setServiceName(String serviceName) {
        String namespaceURI = this._serviceQName.getNamespaceURI();
        this._serviceQName = new QName(namespaceURI, serviceName);
    }

    public String getNamespaceURI() {
        return this._serviceQName.getNamespaceURI();
    }

    public void setNamespaceURI(String namespaceURI) {
        String serviceName = this._serviceQName.getLocalPart();
        this._serviceQName = new QName(namespaceURI, serviceName);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public final boolean equals(Object objectToTest) {
        if (objectToTest == null || !(objectToTest instanceof PortName)) {
            return false;
        }
        PortName portName = (PortName)objectToTest;
        return this._name.equals(portName._name) && this._serviceQName.equals(portName._serviceQName);
    }

    public final int hashCode() {
        return this._serviceQName.hashCode() ^ this._name.hashCode();
    }

    public String toString() {
        if (this._serviceQName != null) {
            return this._serviceQName + ":" + this._name;
        }
        return this._name;
    }
}

