/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard.binding.soap.config.model;

import javax.xml.namespace.QName;
import org.savara.scenario.simulator.switchyard.binding.soap.PortName;
import org.savara.scenario.simulator.switchyard.binding.soap.config.model.ValueModel;
import org.switchyard.common.net.SocketAddr;
import org.switchyard.config.Configuration;
import org.switchyard.config.Configurations;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.composite.v1.V1BindingModel;

public class SOAPBindingModel
extends V1BindingModel {
    public static final String SOAP = "soap";
    public static final String DEFAULT_NAMESPACE = "urn:switchyard-component-soap:config:1.0";
    private static final String WSDL = "wsdl";
    private static final String PORT = "wsdlPort";
    private static final String CONTEXT_PATH = "contextPath";
    private static final String SOCKET_ADDRESS = "socketAddr";
    private PortName _port;
    private String _wsdl;
    private QName _serviceName;
    private SocketAddr _socketAddr;
    private String _contextPath;
    private Boolean _publishAsWS = false;
    private Configuration _environment = Configurations.newConfiguration();

    public SOAPBindingModel() {
        super(SOAP, DEFAULT_NAMESPACE);
        this.setModelChildrenOrder(new String[]{WSDL, PORT, SOCKET_ADDRESS});
    }

    public SOAPBindingModel(Configuration config, Descriptor desc) {
        super(config, desc);
        this.setModelChildrenOrder(new String[]{WSDL, PORT, SOCKET_ADDRESS});
    }

    public PortName getPort() {
        if (this._port == null) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(PORT);
            this._port = childConfig != null ? new PortName(childConfig.getValue()) : new PortName();
        }
        return this._port;
    }

    public void setPort(PortName port) {
        this._port = port;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(PORT);
        if (childConfig == null) {
            ValueModel portConfig = new ValueModel(PORT);
            portConfig.setValue(port.getName());
            this.setChildModel((Model)portConfig);
        } else {
            childConfig.setValue(port.getName());
        }
    }

    public String getWsdl() {
        Configuration childConfig;
        if (this._wsdl == null && (childConfig = this.getModelConfiguration().getFirstChild(WSDL)) != null) {
            this._wsdl = childConfig.getValue();
        }
        return this._wsdl;
    }

    public void setWsdl(String wsdl) {
        this._wsdl = wsdl;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(WSDL);
        if (childConfig == null) {
            ValueModel portConfig = new ValueModel(WSDL);
            portConfig.setValue(wsdl);
            this.setChildModel((Model)portConfig);
        } else {
            childConfig.setValue(wsdl);
        }
    }

    public QName getServiceName() {
        if (this._serviceName == null) {
            this._serviceName = this.isServiceBinding() ? this.getService().getQName() : this.getReference().getQName();
        }
        return this._serviceName;
    }

    public void setServiceName(QName serviceName) {
        this._serviceName = serviceName;
    }

    public SocketAddr getSocketAddr() {
        if (this._socketAddr == null) {
            Configuration hostConfig;
            Configuration childConfig = this.getModelConfiguration().getFirstChild(SOCKET_ADDRESS);
            this._socketAddr = childConfig == null ? ((hostConfig = this._environment.getFirstChild(SOCKET_ADDRESS)) != null && hostConfig.getValue() != null ? new SocketAddr(hostConfig.getValue()) : new SocketAddr()) : new SocketAddr(childConfig.getValue());
        }
        return this._socketAddr;
    }

    public void setSocketAddr(SocketAddr socketAddr) {
        this._socketAddr = socketAddr;
        Configuration childConfig = this.getModelConfiguration().getFirstChild(SOCKET_ADDRESS);
        if (childConfig == null) {
            ValueModel addrConfig = new ValueModel(SOCKET_ADDRESS);
            addrConfig.setValue(socketAddr.toString());
            this.setChildModel((Model)addrConfig);
        } else {
            childConfig.setValue(socketAddr.toString());
        }
    }

    public String getContextPath() {
        if (this._contextPath == null) {
            Configuration childConfig = this.getModelConfiguration().getFirstChild(CONTEXT_PATH);
            if (childConfig == null) {
                Configuration contextConfig = this._environment.getFirstChild(CONTEXT_PATH);
                if (contextConfig != null && contextConfig.getValue() != null) {
                    this._contextPath = contextConfig.getValue();
                }
            } else {
                this._contextPath = childConfig.getValue();
            }
        }
        return this._contextPath;
    }

    public void setContextPath(String contextPath) {
        this._contextPath = contextPath;
    }

    public void setPublishAsWS(Boolean publishAsWS) {
        this._publishAsWS = publishAsWS;
    }

    public Boolean getPublishAsWS() {
        return this._publishAsWS;
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }
}

