/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard.binding.soap.deploy;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.savara.scenario.simulator.switchyard.binding.soap.InboundHandler;
import org.savara.scenario.simulator.switchyard.binding.soap.OutboundHandler;
import org.savara.scenario.simulator.switchyard.binding.soap.config.model.SOAPBindingModel;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.deploy.BaseActivator;
import org.switchyard.deploy.ServiceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPActivator
extends BaseActivator {
    private static final Logger LOG = Logger.getLogger(SOAPActivator.class.getName());
    private static final String SOAP_TYPE = "soap";
    private Configuration _environment;
    private InboundHandler _inboundHandler = null;
    private Map<String, OutboundHandler> _outboundHandler = new HashMap<String, OutboundHandler>();

    public SOAPActivator() {
        super(new String[]{SOAP_TYPE});
    }

    public InboundHandler getInboundHandler() {
        return this._inboundHandler;
    }

    public OutboundHandler getOutboundHandler(String type) {
        return this._outboundHandler.get(type);
    }

    public Map<String, OutboundHandler> getOutboundHandlers() {
        return this._outboundHandler;
    }

    public ServiceHandler activateBinding(QName name, BindingModel config) {
        SOAPBindingModel binding = (SOAPBindingModel)config;
        binding.setEnvironment(this._environment);
        if (binding.isServiceBinding()) {
            if (this._inboundHandler != null) {
                LOG.severe("Inbound handler already set");
            }
            this._inboundHandler = new InboundHandler(binding, this.getServiceDomain());
            return this._inboundHandler;
        }
        if (this._outboundHandler.containsKey(name.getLocalPart())) {
            LOG.severe("Outbound handler for '" + name.getLocalPart() + "' already set");
        }
        OutboundHandler oh = new OutboundHandler(binding);
        this._outboundHandler.put(name.getLocalPart(), oh);
        return oh;
    }

    public void deactivateBinding(QName name, ServiceHandler handler) {
    }

    public void setEnvironment(Configuration config) {
        this._environment = config;
    }
}

