/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulator.switchyard.internal;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.MessageEvent;
import org.savara.scenario.model.Parameter;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;
import org.savara.scenario.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStore {
    private static final int TIMEOUT = 2000;
    private static final Logger LOG = Logger.getLogger(MessageStore.class.getName());
    private List<ReceiveEvent> _receiveEvents = new Vector<ReceiveEvent>();
    private SynchronousQueue<SendEvent> _sendEvents = new SynchronousQueue();
    private SimulationHandler _handler = null;
    private SimulationContext _context = null;

    public void setHandler(SimulationHandler handler) {
        this._handler = handler;
    }

    public Collection<ReceiveEvent> getReceiveEvents() {
        return this._receiveEvents;
    }

    public Collection<SendEvent> getSendEvents() {
        return this._sendEvents;
    }

    public void setSimulationContext(SimulationContext context) {
        this._context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSendEvent(String operation, Object content) throws Exception {
        SendEvent send;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("waitForSendEvent: op=" + operation + " content=" + content);
        }
        if (this.isValidMessage((MessageEvent)(send = this._sendEvents.take()), operation, content)) {
            this._handler.processed((Event)send);
        } else {
            this._handler.unexpected((Event)send);
        }
        SendEvent sendEvent = send;
        synchronized (sendEvent) {
            send.notifyAll();
        }
    }

    public String getMessageContent(String path) {
        String ret = null;
        try {
            InputStream is = this._context.getResource(path);
            byte[] b = new byte[is.available()];
            is.read(b);
            ret = new String(b);
            is.close();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to get parameter value '" + path + "'", e);
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Get value = " + ret);
        }
        return ret;
    }

    protected boolean isValidMessage(MessageEvent event, String operation, Object content) {
        boolean ret = false;
        if (event.getOperationName().equals(operation) && event.getParameter().size() == 1) {
            ret = this.isValidParameter((Parameter)event.getParameter().get(0), content);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Is message op=" + operation + " content=" + content + " valid against event " + event + "? = " + ret);
        }
        return ret;
    }

    protected boolean isValidParameter(Parameter param, Object value) {
        boolean ret = false;
        String paramValue = this.getMessageContent(param.getValue());
        if (paramValue != null && MessageUtil.isValid((String)paramValue, (Object)value)) {
            ret = true;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Is valid parameter '" + param.getValue() + ":" + paramValue + "' = '" + value + "'? " + ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSendEvent(SendEvent send) throws Exception {
        SendEvent sendEvent = send;
        synchronized (sendEvent) {
            if (!this._sendEvents.offer(send, 2000L, TimeUnit.MILLISECONDS)) {
                this._handler.unexpected((Event)send);
            }
            send.wait(2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleReceiveEvent(ReceiveEvent receive) throws Exception {
        ReceiveEvent receiveEvent = receive;
        synchronized (receiveEvent) {
            this._receiveEvents.add(receive);
            List<ReceiveEvent> list = this._receiveEvents;
            synchronized (list) {
                this._receiveEvents.notifyAll();
            }
            receive.wait(2000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiveEvent waitForReceiveEvent(String operation) throws Exception {
        ReceiveEvent ret = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Wait for receive event: op=" + operation);
        }
        List<ReceiveEvent> list = this._receiveEvents;
        synchronized (list) {
            boolean f_found = false;
            long endtime = System.currentTimeMillis() + 2000L;
            do {
                for (ReceiveEvent receive : this._receiveEvents) {
                    if (!receive.getOperationName().equals(operation)) continue;
                    f_found = true;
                    ret = receive;
                    this._receiveEvents.remove(receive);
                    this._handler.processed((Event)receive);
                    ReceiveEvent receiveEvent = receive;
                    synchronized (receiveEvent) {
                        receive.notifyAll();
                        break;
                    }
                }
                if (f_found) continue;
                long delay = endtime - System.currentTimeMillis();
                if (delay <= 0L) {
                    f_found = true;
                    continue;
                }
                this._receiveEvents.wait(delay);
            } while (!f_found);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Returning receive event: op=" + operation + " ret=" + ret);
        }
        return ret;
    }

    public void close() {
        if (this._handler != null) {
            for (MessageEvent messageEvent : this.getReceiveEvents()) {
                this._handler.unexpected((Event)messageEvent);
            }
            for (MessageEvent messageEvent : this.getSendEvents()) {
                this._handler.unexpected((Event)messageEvent);
            }
        }
    }
}

