/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert$;
import org.junit.ComparisonFailure;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Assert$ {
    public static final Assert$ MODULE$ = new Assert$();

    public void assertTrue(String message, boolean condition) {
        block0: {
            if (condition) break block0;
            this.fail(message);
        }
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(null, condition);
    }

    public void assertFalse(String message, boolean condition) {
        this.assertTrue(message, !condition);
    }

    public void assertFalse(boolean condition) {
        this.assertFalse(null, condition);
    }

    public void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public void fail() {
        this.fail(null);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        block3: {
            if (this.equalsRegardingNull(expected, actual)) break block3;
            Tuple2 tuple2 = new Tuple2(expected, actual);
            if (tuple2 != null) {
                Object expectedString = tuple2._1();
                Object actualString = tuple2._2();
                if (expectedString instanceof String) {
                    String string = (String)expectedString;
                    if (actualString instanceof String) {
                        String string2 = (String)actualString;
                        String cleanMsg = message == null ? "" : message;
                        throw new ComparisonFailure(cleanMsg, string, string2);
                    }
                }
            }
            this.failNotEquals(message, expected, actual);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private boolean equalsRegardingNull(Object expected, Object actual) {
        return expected == null ? actual == null : this.org$junit$Assert$$isEquals(expected, actual);
    }

    public boolean org$junit$Assert$$isEquals(Object expected, Object actual) {
        return expected.equals(actual);
    }

    public void assertEquals(Object expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertNotEquals(String message, Object unexpected, Object actual) {
        block0: {
            if (!this.equalsRegardingNull(unexpected, actual)) break block0;
            this.failEquals(message, actual);
        }
    }

    public void assertNotEquals(Object unexpected, Object actual) {
        this.assertNotEquals(null, unexpected, actual);
    }

    private void failEquals(String message, Object actual) {
        String checkedMessage = message != null ? message : "Values should be different";
        this.fail(new StringBuilder(10).append(checkedMessage).append(". Actual: ").append(actual).toString());
    }

    public void assertNotEquals(String message, long unexpected, long actual) {
        block0: {
            if (unexpected != actual) break block0;
            this.failEquals(message, BoxesRunTime.boxToLong((long)actual));
        }
    }

    public void assertNotEquals(long unexpected, long actual) {
        this.assertNotEquals((String)null, unexpected, actual);
    }

    public void assertNotEquals(String message, double unexpected, double actual, double delta) {
        block0: {
            if (this.doubleIsDifferent(unexpected, actual, delta)) break block0;
            this.failEquals(message, BoxesRunTime.boxToDouble((double)actual));
        }
    }

    public void assertNotEquals(double unexpected, double actual, double delta) {
        this.assertNotEquals(null, unexpected, actual, delta);
    }

    public void assertNotEquals(float unexpected, float actual, float delta) {
        this.assertNotEquals((String)null, unexpected, actual, delta);
    }

    public void assertEquals(double expected, double actual) {
        this.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public void assertEquals(String message, double expected, double actual) {
        this.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public void assertEquals(long expected, long actual) {
        this.assertEquals((String)null, expected, actual);
    }

    public void assertEquals(String message, long expected, long actual) {
        this.assertEquals(message, BoxesRunTime.boxToLong((long)expected), BoxesRunTime.boxToLong((long)actual));
    }

    public void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        this.assertArrayEquals(null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, boolean[] expecteds, boolean[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(boolean[] expecteds, boolean[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, char[] expecteds, char[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(char[] expecteds, char[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, short[] expecteds, short[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(short[] expecteds, short[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, int[] expecteds, int[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(int[] expecteds, int[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, long[] expecteds, long[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(long[] expecteds, long[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) {
        new InexactComparisonCriteria(delta).arrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        this.assertArrayEquals(null, expecteds, actuals, delta);
    }

    public void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) {
        new InexactComparisonCriteria(delta).arrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        this.assertArrayEquals((String)null, expecteds, actuals, delta);
    }

    private void internalArrayEquals(String message, Object expecteds, Object actuals) {
        new ExactComparisonCriteria().arrayEquals(message, expecteds, actuals);
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        block0: {
            if (!this.doubleIsDifferent(expected, actual, delta)) break block0;
            this.failNotEquals(message, BoxesRunTime.boxToDouble((double)expected), BoxesRunTime.boxToDouble((double)actual));
        }
    }

    public void assertEquals(String message, float expected, float actual, float delta) {
        block0: {
            if (!this.floatIsDifferent(expected, actual, delta)) break block0;
            this.failNotEquals(message, BoxesRunTime.boxToFloat((float)expected), BoxesRunTime.boxToFloat((float)actual));
        }
    }

    public void assertNotEquals(String message, float unexpected, float actual, float delta) {
        block0: {
            if (this.floatIsDifferent(unexpected, actual, delta)) break block0;
            this.failEquals(message, BoxesRunTime.boxToFloat((float)actual));
        }
    }

    private boolean doubleIsDifferent(double d1, double d2, double delta) {
        return Double.compare(d1, d2) != 0 && Math.abs(d1 - d2) > delta;
    }

    private boolean floatIsDifferent(float f1, float f2, float delta) {
        return Float.compare(f1, f2) != 0 && Math.abs(f1 - f2) > delta;
    }

    public void assertEquals(double expected, double actual, double delta) {
        this.assertEquals(null, expected, actual, delta);
    }

    public void assertEquals(float expected, float actual, float delta) {
        this.assertEquals((String)null, expected, actual, delta);
    }

    public void assertNotNull(String message, Object obj) {
        this.assertTrue(message, obj != null);
    }

    public void assertNotNull(Object obj) {
        this.assertNotNull(null, obj);
    }

    public void assertNull(String message, Object obj) {
        block0: {
            if (obj == null) break block0;
            this.failNotNull(message, obj);
        }
    }

    public void assertNull(Object obj) {
        this.assertNull(null, obj);
    }

    private void failNotNull(String message, Object actual) {
        String formatted = message != null ? new StringBuilder(1).append(message).append(" ").toString() : "";
        this.fail(new StringBuilder(26).append(formatted).append("expected null, but was:<").append(actual).append("}>").toString());
    }

    public void assertSame(String message, Object expected, Object actual) {
        block0: {
            if (expected == actual) break block0;
            this.failNotSame(message, expected, actual);
        }
    }

    public void assertSame(Object expected, Object actual) {
        this.assertSame(null, expected, actual);
    }

    public void assertNotSame(String message, Object unexpected, Object actual) {
        block0: {
            if (unexpected != actual) break block0;
            this.failSame(message);
        }
    }

    public void assertNotSame(Object unexpected, Object actual) {
        this.assertNotSame(null, unexpected, actual);
    }

    private void failSame(String message) {
        if (message == null) {
            this.fail("expected not same");
        } else {
            this.fail(new StringBuilder(18).append(message).append(" expected not same").toString());
        }
    }

    private void failNotSame(String message, Object expected, Object actual) {
        if (message == null) {
            this.fail(new StringBuilder(27).append("expected same:<").append(expected).append("> was not:<").append(actual).append(">").toString());
        } else {
            this.fail(new StringBuilder(28).append(message).append(" expected same:<").append(expected).append("> was not:<").append(actual).append(">").toString());
        }
    }

    private void failNotEquals(String message, Object expected, Object actual) {
        this.fail(this.format(message, expected, actual));
    }

    /*
     * Unable to fully structure code
     */
    public String format(String message, Object expected, Object actual) {
        if (message == null) ** GOTO lbl-1000
        v0 = message;
        var5_4 = "";
        if (v0 == null ? var5_4 != null : v0.equals(var5_4) == false) {
            v1 = new StringBuilder(1).append(message).append(" ").toString();
        } else lbl-1000:
        // 2 sources

        {
            v1 = "";
        }
        formatted = v1;
        expectedString = String.valueOf(expected);
        actualString = String.valueOf(actual);
        v2 = expectedString;
        var8_8 = actualString;
        if (!(v2 != null ? v2.equals(var8_8) == false : var8_8 != null)) {
            expectedFormatted = this.formatClassAndValue(expected, expectedString);
            actualFormatted = this.formatClassAndValue(actual, actualString);
            v3 = new StringBuilder(20).append(formatted).append("expected: ").append(expectedFormatted).append(" but was: ").append(actualFormatted).toString();
        } else {
            v3 = new StringBuilder(22).append(formatted).append("expected:<").append(expectedString).append("> but was:<").append(actualString).append(">").toString();
        }
        return v3;
    }

    private String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return new StringBuilder(2).append(className).append("<").append(valueString).append(">").toString();
    }

    public <T> void assertThat(T actual, Matcher<T> matcher) {
        this.assertThat("", actual, matcher);
    }

    public <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        MatcherAssert$.MODULE$.assertThat(reason, actual, matcher);
    }

    private Assert$() {
    }
}

