/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Either;
import scala.Function1;
import scala.Function2;
import scala.Left;
import scala.MatchError;
import scala.Right;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.generic.SeqFactory;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class List$
extends SeqFactory<List> {
    public static final List$ MODULE$;

    static {
        new List$();
    }

    public <A> CanBuildFrom<List<?>, A, List<A>> canBuildFrom() {
        return this.ReusableCBF();
    }

    @Override
    public <A> Builder<A, List<A>> newBuilder() {
        return new ListBuffer();
    }

    @Override
    public <A> List<A> empty() {
        return Nil$.MODULE$;
    }

    @Override
    public <A> List<A> apply(Seq<A> xs) {
        return xs.toList();
    }

    public List<Object> range(int start, int end, Function1<Object, Object> step) {
        boolean up2 = step.apply$mcII$sp(start) > start;
        boolean down = step.apply$mcII$sp(start) < start;
        ListBuffer b = new ListBuffer();
        int i = start;
        while (!(up2 && i >= end || down && i <= end)) {
            b.$plus$eq(BoxesRunTime.boxToInteger(i));
            int next2 = step.apply$mcII$sp(i);
            if (i == next2) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"the step function did not make any progress on ").append(BoxesRunTime.boxToInteger(i)).toString());
            }
            i = next2;
        }
        return b.toList();
    }

    public <A> List<A> make(int n, A elem2) {
        ListBuffer b = new ListBuffer();
        for (int i = 0; i < n; ++i) {
            b.$plus$eq((Object)elem2);
        }
        return b.toList();
    }

    public <A> List<A> flatten(List<List<A>> xss) {
        ListBuffer b$1 = new ListBuffer();
        xss.foreach(new Serializable(b$1){
            public static final long serialVersionUID;
            private final ListBuffer b$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(List<A> xs) {
                List xc = xs;
                while (!xc.isEmpty()) {
                    this.b$1.$plus$eq((Object)xc.head());
                    xc = (List)xc.tail();
                }
                return;
            }
            {
                this.b$1 = listBuffer;
            }
        });
        return b$1.toList();
    }

    public <A, B> Tuple2<List<A>, List<B>> unzip(List<Tuple2<A, B>> xs) {
        ListBuffer b1 = new ListBuffer();
        ListBuffer b2 = new ListBuffer();
        List xc = xs;
        while (!xc.isEmpty()) {
            b1.$plus$eq(((Tuple2)xc.head())._1());
            b2.$plus$eq(((Tuple2)xc.head())._2());
            xc = (List)xc.tail();
        }
        return new Tuple2<List<A>, List<B>>(b1.toList(), b2.toList());
    }

    public <A, B> Tuple2<List<A>, List<B>> unzip(Iterable<Tuple2<A, B>> xs) {
        return xs.foldRight(new Tuple2<Nil$, Nil$>(Nil$.MODULE$, Nil$.MODULE$), new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<List<A>, List<B>> apply(Tuple2<A, B> tuple2, Tuple2<List<A>, List<B>> tuple22) {
                Tuple2<Tuple2<A, B>, Tuple2<List<A>, List<B>>> tuple23 = new Tuple2<Tuple2<A, B>, Tuple2<List<A>, List<B>>>(tuple2, tuple22);
                if (tuple23 != null && tuple23._1() != null && tuple23._2() != null) {
                    A a = tuple23._1()._1();
                    B b = tuple23._1()._2();
                    return new Tuple2<List<A>, List<B>>(tuple23._2()._1().$colon$colon(a), tuple23._2()._2().$colon$colon(b));
                }
                throw new MatchError(tuple23);
            }
        });
    }

    public <A, B> List<A> lefts(Iterable<Either<A, B>> es) {
        return es.foldRight(Nil$.MODULE$, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<A> apply(Either<A, B> either2, List<A> list2) {
                block4: {
                    List<A> list3;
                    block3: {
                        Right x4;
                        block2: {
                            Left x2;
                            if (!(either2 instanceof Left) || (x2 = (Left)either2) == null) break block2;
                            A a = x2.a();
                            list3 = list2.$colon$colon(a);
                            break block3;
                        }
                        if (!(either2 instanceof Right) || (x4 = (Right)either2) == null) break block4;
                        list3 = list2;
                    }
                    return list3;
                }
                throw new MatchError(either2);
            }
        });
    }

    public <A, B> List<B> rights(Iterable<Either<A, B>> es) {
        return es.foldRight(Nil$.MODULE$, new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final List<B> apply(Either<A, B> either2, List<B> list2) {
                block4: {
                    List<B> list3;
                    block3: {
                        Right x4;
                        block2: {
                            Left x3;
                            if (!(either2 instanceof Left) || (x3 = (Left)either2) == null) break block2;
                            list3 = list2;
                            break block3;
                        }
                        if (!(either2 instanceof Right) || (x4 = (Right)either2) == null) break block4;
                        B b = x4.b();
                        list3 = list2.$colon$colon(b);
                    }
                    return list3;
                }
                throw new MatchError(either2);
            }
        });
    }

    public <A, B> Tuple2<List<A>, List<B>> separate(Iterable<Either<A, B>> es) {
        return es.foldRight(new Tuple2<Nil$, Nil$>(Nil$.MODULE$, Nil$.MODULE$), new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<List<A>, List<B>> apply(Either<A, B> either2, Tuple2<List<A>, List<B>> tuple2) {
                Tuple2<Either<A, B>, Tuple2<List<A>, List<B>>> tuple22;
                block4: {
                    Tuple2<List<A>, List<B>> tuple23;
                    block3: {
                        Right x7;
                        block2: {
                            Left x4;
                            tuple22 = new Tuple2<Either<A, B>, Tuple2<List<A>, List<B>>>(either2, tuple2);
                            if (tuple22 == null || !(tuple22._1() instanceof Left) || (x4 = (Left)tuple22._1()) == null || tuple22._2() == null) break block2;
                            A a = x4.a();
                            tuple23 = new Tuple2<List<A>, List<B>>(tuple22._2()._1().$colon$colon(a), tuple22._2()._2());
                            break block3;
                        }
                        if (tuple22 == null || !(tuple22._1() instanceof Right) || (x7 = (Right)tuple22._1()) == null || tuple22._2() == null) break block4;
                        B b = x7.b();
                        tuple23 = new Tuple2<List<A>, List<B>>(tuple22._2()._1(), tuple22._2()._2().$colon$colon(b));
                    }
                    return tuple23;
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public <A> List<A> fromIterator(Iterator<A> it) {
        return it.toList();
    }

    public <A> List<A> fromArray(Object arr) {
        return this.fromArray(arr, 0, ScalaRunTime$.MODULE$.array_length(arr));
    }

    public <A> List<A> fromArray(Object arr, int start, int len) {
        List res = Nil$.MODULE$;
        int i = start + len;
        while (i > start) {
            Object object = ScalaRunTime$.MODULE$.array_apply(arr, --i);
            res = res.$colon$colon(object);
        }
        return res;
    }

    public <A, B, C> List<C> map2(List<A> xs, List<B> ys, Function2<A, B, C> f) {
        ListBuffer b = new ListBuffer();
        List xc = xs;
        List yc = ys;
        while (!xc.isEmpty() && !yc.isEmpty()) {
            b.$plus$eq(f.apply(xc.head(), yc.head()));
            xc = (List)xc.tail();
            yc = (List)yc.tail();
        }
        return b.toList();
    }

    public <A, B> boolean forall2(List<A> xs, List<B> ys, Function2<A, B, Object> f) {
        List xc = xs;
        List yc = ys;
        while (true) {
            if (xc.isEmpty() || yc.isEmpty()) {
                return true;
            }
            if (!BoxesRunTime.unboxToBoolean(f.apply(xc.head(), yc.head()))) break;
            xc = (List)xc.tail();
            yc = (List)yc.tail();
        }
        return false;
    }

    public <A, B> boolean exists2(List<A> xs, List<B> ys, Function2<A, B, Object> f) {
        List xc = xs;
        List yc = ys;
        while (!xc.isEmpty() && !yc.isEmpty()) {
            if (BoxesRunTime.unboxToBoolean(f.apply(xc.head(), yc.head()))) {
                return true;
            }
            xc = (List)xc.tail();
            yc = (List)yc.tail();
        }
        return false;
    }

    public <A> List<List<A>> transpose(List<List<A>> xss) {
        ListBuffer buf = new ListBuffer();
        List<List<A>> yss = xss;
        while (!((IterableLike)yss.head()).isEmpty()) {
            buf.$plus$eq(yss.map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final A apply(List<A> list2) {
                    return list2.head();
                }
            }, this.canBuildFrom()));
            yss = yss.map(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final List<A> apply(List<A> list2) {
                    return (List)list2.tail();
                }
            }, this.canBuildFrom());
        }
        return buf.toList();
    }

    private List$() {
        MODULE$ = this;
    }
}

