/*
 * Decompiled with CFR 0.152.
 */
package sbt.io;

import java.io.Serializable;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.List;
import java.util.concurrent.TimeUnit;
import sbt.io.Unregisterable;
import sbt.io.WatchService$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%t!B\u000e\u001d\u0011\u0003\tc!B\u0012\u001d\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003ac\u0001B\u0017\u0002\u00079B\u0001b_\u0002\u0003\u0002\u0003\u0006I\u0001 \u0005\u0006W\r!\tA \u0005\n\u0003\u000b\u0019\u0001\u0019!C\u0005\u0003\u000fA\u0011\"a\u0004\u0004\u0001\u0004%I!!\u0005\t\u0011\u0005]1\u0001)Q\u0005\u0003\u0013A\u0011\"!\u0007\u0004\u0005\u0004%I!a\u0007\t\u0011\u0005\u001d2\u0001)A\u0005\u0003;AQ!M\u0002\u0005BIBQAN\u0002\u0005B]BaaW\u0002\u0005B\u0005%\u0002BB4\u0004\t\u0003\nY\u0004C\u0004\u0002B\r!\t%a\u0011\t\u000b]\u001cA\u0011\t\u001a\t\u000f\u0005\u001d3\u0001\"\u0011\u0002J!I\u0011\u0011K\u0001\u0002\u0002\u0013\u001d\u00111\u000b\u0005\t\u0003/\nA\u0011\u0001\u0010\u0002Z!9\u00111L\u0001\u0005\u0002\u0005ucaB\u0012\u001d!\u0003\r\n\u0001\r\u0005\u0006cU1\tA\r\u0005\u0006mU1\ta\u000e\u0005\u00067V1\t\u0001\u0018\u0005\u0006OV1\t\u0001\u001b\u0005\u0006oV1\tAM\u0001\r/\u0006$8\r[*feZL7-\u001a\u0006\u0003;y\t!![8\u000b\u0003}\t1a\u001d2u\u0007\u0001\u0001\"AI\u0001\u000e\u0003q\u0011AbV1uG\"\u001cVM\u001d<jG\u0016\u001c\"!A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011EA\nXCR\u001c\u0007nU3sm&\u001cW-\u00113baR,'o\u0005\u0003\u0004K=B\bC\u0001\u0012\u0016'\t)R%\u0001\u0003j]&$H#A\u001a\u0011\u0005\u0019\"\u0014BA\u001b(\u0005\u0011)f.\u001b;\u0002\u0015A|G\u000e\\#wK:$8\u000fF\u00019!\u0011I\u0004iQ'\u000f\u0005ir\u0004CA\u001e(\u001b\u0005a$BA\u001f!\u0003\u0019a$o\\8u}%\u0011qhJ\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0013%aA'ba*\u0011qh\n\t\u0003\t.k\u0011!\u0012\u0006\u0003\r\u001e\u000bAAZ5mK*\u0011\u0001*S\u0001\u0004]&|'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u0016\u0013\u0001bV1uG\"\\U-\u001f\t\u0004\u001dN+V\"A(\u000b\u0005A\u000b\u0016!C5n[V$\u0018M\u00197f\u0015\t\u0011v%\u0001\u0006d_2dWm\u0019;j_:L!\u0001V(\u0003\u0007M+\u0017\u000fE\u0002E-bK!aV#\u0003\u0015]\u000bGo\u00195Fm\u0016tG\u000f\u0005\u0002E3&\u0011!,\u0012\u0002\u0005!\u0006$\b.\u0001\u0003q_2dGCA\"^\u0011\u0015q\u0006\u00041\u0001`\u0003\u001d!\u0018.\\3pkR\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u0011\u0011,(/\u0019;j_:T!\u0001Z\u0014\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002gC\nAA)\u001e:bi&|g.\u0001\u0005sK\u001eL7\u000f^3s)\r\u0019\u0015n\u001b\u0005\u0006Uf\u0001\r\u0001W\u0001\u0005a\u0006$\b\u000eC\u0003m3\u0001\u0007Q.\u0001\u0004fm\u0016tGo\u001d\t\u0004M9\u0004\u0018BA8(\u0005)a$/\u001a9fCR,GM\u0010\t\u0004cRDfB\u0001#s\u0013\t\u0019X)\u0001\u0006XCR\u001c\u0007.\u0012<f]RL!!\u001e<\u0003\t-Kg\u000e\u001a\u0006\u0003g\u0016\u000bQa\u00197pg\u0016\u0004\"AI=\n\u0005id\"AD+oe\u0016<\u0017n\u001d;fe\u0006\u0014G.Z\u0001\bg\u0016\u0014h/[2f!\t!U0\u0003\u0002$\u000bR\u0019q0a\u0001\u0011\u0007\u0005\u00051!D\u0001\u0002\u0011\u0015YX\u00011\u0001}\u0003\u0019\u0019Gn\\:fIV\u0011\u0011\u0011\u0002\t\u0004M\u0005-\u0011bAA\u0007O\t9!i\\8mK\u0006t\u0017AC2m_N,Gm\u0018\u0013fcR\u00191'a\u0005\t\u0013\u0005Uq!!AA\u0002\u0005%\u0011a\u0001=%c\u000591\r\\8tK\u0012\u0004\u0013A\u0003:fO&\u001cH/\u001a:fIV\u0011\u0011Q\u0004\t\u0007\u0003?\t)\u0003W\"\u000e\u0005\u0005\u0005\"bAA\u0012#\u00069Q.\u001e;bE2,\u0017bA!\u0002\"\u0005Y!/Z4jgR,'/\u001a3!)\r\u0019\u00151\u0006\u0005\u0006=6\u0001\ra\u0018\u0015\u0004\u001b\u0005=\u0002\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ur%\u0001\u0006b]:|G/\u0019;j_:LA!!\u000f\u00024\t9A/Y5me\u0016\u001cG#B\"\u0002>\u0005}\u0002\"\u00026\u000f\u0001\u0004A\u0006\"\u00027\u000f\u0001\u0004i\u0017AC;oe\u0016<\u0017n\u001d;feR\u00191'!\u0012\t\u000b)|\u0001\u0019\u0001-\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0013\u0011\u0007e\ni%C\u0002\u0002P\t\u0013aa\u0015;sS:<\u0017aE,bi\u000eD7+\u001a:wS\u000e,\u0017\tZ1qi\u0016\u0014HcA@\u0002V!)1P\u0005a\u0001y\u00069A-\u001a4bk2$X#A\u0018\u0002\u000fA|G\u000e\\5oOR\u0019q&a\u0018\t\u000f\u0005\u0005D\u00031\u0001\u0002d\u0005)A-\u001a7bsB\u0019\u0001-!\u001a\n\u0007\u0005\u001d\u0014M\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8")
public interface WatchService {
    public static WatchService polling(FiniteDuration delay) {
        return WatchService$.MODULE$.polling(delay);
    }

    public static WatchServiceAdapter WatchServiceAdapter(java.nio.file.WatchService service) {
        return WatchService$.MODULE$.WatchServiceAdapter(service);
    }

    public void init();

    public Map<WatchKey, Seq<WatchEvent<Path>>> pollEvents();

    public WatchKey poll(Duration var1);

    public WatchKey register(Path var1, Seq<WatchEvent.Kind<Path>> var2);

    public void close();

    public static final class WatchServiceAdapter
    implements WatchService,
    Unregisterable {
        private final java.nio.file.WatchService service;
        private boolean closed;
        private final scala.collection.mutable.Map<Path, WatchKey> registered;

        private boolean closed() {
            return this.closed;
        }

        private void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        private scala.collection.mutable.Map<Path, WatchKey> registered() {
            return this.registered;
        }

        @Override
        public void init() {
        }

        @Override
        public Map<WatchKey, Seq<WatchEvent<Path>>> pollEvents() {
            IndexedSeq indexedSeq;
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered();
            synchronized (map) {
                indexedSeq = this.registered().values().toIndexedSeq();
            }
            IndexedSeq values = indexedSeq;
            return ((IterableOnceOps)values.flatMap((Function1 & Serializable)k -> {
                List<WatchEvent<?>> events = k.pollEvents();
                if (events.isEmpty()) {
                    return None$.MODULE$;
                }
                return new Some((Object)new Tuple2(k, (Object)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(events).asScala()).toIndexedSeq()));
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        @Override
        public WatchKey poll(Duration timeout) {
            WatchKey watchKey;
            do {
                if (!timeout.isFinite()) continue;
                return this.service.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
            } while ((watchKey = this.service.poll(1000L, TimeUnit.MILLISECONDS)) == null);
            return watchKey;
        }

        @Override
        public WatchKey register(Path path, Seq<WatchEvent.Kind<Path>> events) {
            WatchKey watchKey;
            if (this.closed()) {
                throw new ClosedWatchServiceException();
            }
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered();
            synchronized (map) {
                WatchKey watchKey2;
                Option option = this.registered().get((Object)path);
                if (None$.MODULE$.equals(option)) {
                    WatchKey key = path.register(this.service, (WatchEvent.Kind[])events.toArray(ClassTag$.MODULE$.apply(WatchEvent.Kind.class)));
                    this.registered().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)key));
                    watchKey2 = key;
                } else if (option instanceof Some) {
                    WatchKey key;
                    Some some = (Some)option;
                    watchKey2 = key = (WatchKey)some.value();
                } else {
                    throw new MatchError((Object)option);
                }
                watchKey = watchKey2;
            }
            return watchKey;
        }

        @Override
        public void unregister(Path path) {
            if (this.closed()) {
                throw new ClosedWatchServiceException();
            }
            scala.collection.mutable.Map<Path, WatchKey> map = this.registered();
            synchronized (map) {
                Option option = this.registered().get((Object)path);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    WatchKey key = (WatchKey)some.value();
                    key.cancel();
                    this.registered().$minus$eq((Object)path);
                }
            }
        }

        @Override
        public void close() {
            this.closed_$eq(true);
            this.service.close();
        }

        public String toString() {
            return this.service.toString();
        }

        public WatchServiceAdapter(java.nio.file.WatchService service) {
            this.service = service;
            this.closed = false;
            this.registered = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        }
    }
}

