/*
 * Decompiled with CFR 0.152.
 */
package org.scalafmt.dynamic;

import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Path;
import org.scalafmt.dynamic.ScalafmtConfigLoader;
import org.scalafmt.dynamic.ScalafmtDynamicError;
import org.scalafmt.dynamic.ScalafmtDynamicError$ConfigParseError$;
import org.scalafmt.dynamic.ScalafmtModuleLoader;
import org.scalafmt.dynamic.ScalafmtProperties;
import org.scalafmt.dynamic.ScalafmtReflectConfig;
import org.scalafmt.dynamic.ScalafmtVersion;
import org.scalafmt.dynamic.ScalafmtVersion$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ScalafmtConfigLoader$
implements ScalafmtConfigLoader {
    public static final ScalafmtConfigLoader$ MODULE$ = new ScalafmtConfigLoader$();

    @Override
    public Either<ScalafmtDynamicError, ScalafmtReflectConfig> load(Path configPath, ScalafmtProperties properties, ScalafmtModuleLoader moduleLoader) {
        return this.readVersion(configPath).flatMap((Function1 & Serializable)version -> moduleLoader.load(configPath, (ScalafmtVersion)version, properties).flatMap((Function1 & Serializable)loaded -> loaded.parseConfig(configPath).toEither().left().map((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof ScalafmtDynamicError) {
                ScalafmtDynamicError scalafmtDynamicError = (ScalafmtDynamicError)throwable;
                return scalafmtDynamicError;
            }
            return new ScalafmtDynamicError.UnknownConfigError(configPath, throwable);
        }).map((Function1 & Serializable)config -> {
            properties.reporter().parsedConfig(configPath, config.getVersion().toString());
            return config;
        })));
    }

    private Either<ScalafmtDynamicError, ScalafmtVersion> readVersion(Path config) {
        Throwable e;
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> ConfigFactory.parseFile((File)config.toFile()).getString("version"));
        if (try_ instanceof Failure) {
            ConfigException.IO iO;
            bl = true;
            failure = (Failure)try_;
            Throwable e2 = failure.exception();
            if (e2 instanceof ConfigException.IO && (iO = (ConfigException.IO)e2).getCause() instanceof FileNotFoundException) {
                return new Left((Object)new ScalafmtDynamicError.ConfigDoesNotExist(config));
            }
        }
        if (bl && (e = failure.exception()) instanceof ConfigException.Parse) {
            ConfigException.Parse parse = (ConfigException.Parse)e;
            return new Left((Object)new ScalafmtDynamicError.ConfigParseError(config, parse.getMessage(), ScalafmtDynamicError$ConfigParseError$.MODULE$.$lessinit$greater$default$3()));
        }
        if (bl && failure.exception() instanceof ConfigException.Missing) {
            return new Left((Object)new ScalafmtDynamicError.ConfigMissingVersion(config));
        }
        if (bl) {
            Throwable e3 = failure.exception();
            return new Left((Object)new ScalafmtDynamicError.UnknownConfigError(config, e3));
        }
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String v = (String)success.value();
            return ScalafmtVersion$.MODULE$.parse(v).toRight((Function0 & Serializable)() -> new ScalafmtDynamicError.ConfigInvalidVersion(config, v));
        }
        throw new MatchError((Object)try_);
    }

    private ScalafmtConfigLoader$() {
    }
}

