/*
 * Decompiled with CFR 0.152.
 */
package breeze.signal.support;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.numerics.package$isOdd$;
import breeze.signal.OptOverhang;
import breeze.signal.OptOverhang$None$;
import breeze.signal.OptOverhang$PreserveLength$;
import breeze.signal.support.CanFilterMedian;
import breeze.stats.package$;
import breeze.util.quickSelectImpl$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class CanFilterMedian$ {
    public static CanFilterMedian$ MODULE$;

    static {
        new CanFilterMedian$();
    }

    public CanFilterMedian<Object> dvFilterMedianT_Int() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger((int)windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0 & Serializable & scala.Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0 & Serializable & scala.Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0 & Serializable & scala.Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcI$sp();
                } else {
                    Vector vector2;
                    int currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef tempret = ObjectRef.create((Object)new int[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexFromBeginning -> {
                            ((int[])tempret$1.elem)[indexFromBeginning] = BoxesRunTime.unboxToInt((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Int()));
                        });
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexToEnd -> {
                            ((int[])tempret$1.elem)[data$1.length() - indexToEnd - 1] = BoxesRunTime.unboxToInt((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Int()));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException("Option " + optOverhang2 + " is invalid here.");
                        }
                        throw new MatchError((Object)optOverhang);
                    }
                    index = halfWindow;
                    int[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), index + halfWindow), DenseVector$.MODULE$.canSlice()).toArray$mcI$sp((ClassTag<Object>)ClassTag$.MODULE$.Int());
                    ((int[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToInt((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Int()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        int newWindowValue;
                        int nowObsoleteWindowValue = data.apply$mcI$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcI$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if (!(nowObsoleteWindowValue < currentMedian && newWindowValue < currentMedian || nowObsoleteWindowValue > currentMedian && newWindowValue > currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToInt((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Int()));
                            }
                        }
                        ((int[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mIc$sp((int[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mIc$sp((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])tempret.elem)).slice(halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError((Object)optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(int[] arr, int fromValue, int toValue, int pivotPoint) {
                int pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0 & Serializable & scala.Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$1(), $anonfun$apply$2(), $anonfun$apply$3(), $anonfun$apply$4(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$apply$5(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$findAndReplaceInstanceInPlace$1()}, serializedLambda);
            }
        };
    }

    public CanFilterMedian<Object> dvFilterMedianT_Long() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector<Object> vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger((int)windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0 & Serializable & scala.Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0 & Serializable & scala.Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0 & Serializable & scala.Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcJ$sp();
                } else {
                    Vector vector2;
                    long currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef tempret = ObjectRef.create((Object)new long[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexFromBeginning -> {
                            ((long[])tempret$2.elem)[indexFromBeginning] = BoxesRunTime.unboxToLong((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Long()));
                        });
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexToEnd -> {
                            ((long[])tempret$2.elem)[data$2.length() - indexToEnd - 1] = BoxesRunTime.unboxToLong((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Long()));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException("Option " + optOverhang2 + " is invalid here.");
                        }
                        throw new MatchError((Object)optOverhang);
                    }
                    index = halfWindow;
                    long[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), index + halfWindow), DenseVector$.MODULE$.canSlice()).toArray$mcJ$sp((ClassTag<Object>)ClassTag$.MODULE$.Long());
                    ((long[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToLong((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Long()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        long newWindowValue;
                        long nowObsoleteWindowValue = data.apply$mcJ$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcJ$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if (!(nowObsoleteWindowValue < currentMedian && newWindowValue < currentMedian || nowObsoleteWindowValue > currentMedian && newWindowValue > currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToLong((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Long()));
                            }
                        }
                        ((long[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mJc$sp((long[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mJc$sp((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])tempret.elem)).slice(halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError((Object)optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(long[] arr, long fromValue, long toValue, int pivotPoint) {
                long pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0 & Serializable & scala.Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$6(), $anonfun$apply$7(), $anonfun$apply$8(), $anonfun$apply$9(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$apply$10(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$findAndReplaceInstanceInPlace$2()}, serializedLambda);
            }
        };
    }

    public CanFilterMedian<Object> dvFilterMedianT_Double() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger((int)windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0 & Serializable & scala.Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0 & Serializable & scala.Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0 & Serializable & scala.Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcD$sp();
                } else {
                    Vector vector2;
                    double currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef tempret = ObjectRef.create((Object)new double[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexFromBeginning -> {
                            ((double[])tempret$3.elem)[indexFromBeginning] = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Double()));
                        });
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexToEnd -> {
                            ((double[])tempret$3.elem)[data$3.length() - indexToEnd - 1] = BoxesRunTime.unboxToDouble((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Double()));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException("Option " + optOverhang2 + " is invalid here.");
                        }
                        throw new MatchError((Object)optOverhang);
                    }
                    index = halfWindow;
                    double[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), index + halfWindow), DenseVector$.MODULE$.canSlice()).toArray$mcD$sp((ClassTag<Object>)ClassTag$.MODULE$.Double());
                    ((double[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToDouble((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Double()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        double newWindowValue;
                        double nowObsoleteWindowValue = data.apply$mcD$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcD$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if ((nowObsoleteWindowValue >= currentMedian || newWindowValue >= currentMedian) && (nowObsoleteWindowValue <= currentMedian || newWindowValue <= currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToDouble((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Double()));
                            }
                        }
                        ((double[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mDc$sp((double[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mDc$sp((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])tempret.elem)).slice(halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError((Object)optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(double[] arr, double fromValue, double toValue, int pivotPoint) {
                double pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0 & Serializable & scala.Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$11(), $anonfun$apply$12(), $anonfun$apply$13(), $anonfun$apply$14(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$apply$15(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$findAndReplaceInstanceInPlace$3()}, serializedLambda);
            }
        };
    }

    public CanFilterMedian<Object> dvFilterMedianT_Float() {
        return new CanFilterMedian<Object>(){

            public DenseVector<Object> apply(DenseVector<Object> data, int windowLength, OptOverhang overhang) {
                Vector vector;
                Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)package$isOdd$.MODULE$.apply(BoxesRunTime.boxToInteger((int)windowLength), package$isOdd$.MODULE$.isOddImpl_Int())), (Function0 & Serializable & scala.Serializable)() -> "median filter can only take odd windowLength values, since even values will cause a half-frame time shift");
                Predef$.MODULE$.require(data.length() >= 3, (Function0 & Serializable & scala.Serializable)() -> "data must be longer than 3");
                Predef$.MODULE$.require(windowLength >= 1, (Function0 & Serializable & scala.Serializable)() -> "window length must be longer than 1");
                if (windowLength == 1) {
                    vector = data.copy$mcF$sp();
                } else {
                    Vector vector2;
                    float currentMedian;
                    BoxedUnit boxedUnit;
                    int halfWindow;
                    ObjectRef tempret = ObjectRef.create((Object)new float[data.length()]);
                    int index = halfWindow = (windowLength - 1) / 2;
                    OptOverhang optOverhang = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang)) {
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexFromBeginning -> {
                            ((float[])tempret$4.elem)[indexFromBeginning] = BoxesRunTime.unboxToFloat((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), indexFromBeginning * 2), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Float()));
                        });
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), halfWindow).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)indexToEnd -> {
                            ((float[])tempret$4.elem)[data$4.length() - indexToEnd - 1] = BoxesRunTime.unboxToFloat((Object)package$.MODULE$.median().apply(data.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(data.length() - 2 * indexToEnd - 1), data.length()), DenseVector$.MODULE$.canSlice()), package$.MODULE$.median().reduce_Float()));
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (optOverhang != null) {
                            OptOverhang optOverhang2 = optOverhang;
                            throw new IllegalArgumentException("Option " + optOverhang2 + " is invalid here.");
                        }
                        throw new MatchError((Object)optOverhang);
                    }
                    index = halfWindow;
                    float[] tempDataExtract = data.apply(RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), index + halfWindow), DenseVector$.MODULE$.canSlice()).toArray$mcF$sp((ClassTag<Object>)ClassTag$.MODULE$.Float());
                    ((float[])tempret.elem)[index] = currentMedian = BoxesRunTime.unboxToFloat((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Float()));
                    ++index;
                    while (index < data.length() - halfWindow) {
                        float newWindowValue;
                        float nowObsoleteWindowValue = data.apply$mcF$sp(index - halfWindow - 1);
                        if (nowObsoleteWindowValue != (newWindowValue = data.apply$mcF$sp(index + halfWindow))) {
                            this.findAndReplaceInstanceInPlace(tempDataExtract, nowObsoleteWindowValue, newWindowValue, halfWindow);
                            if ((nowObsoleteWindowValue >= currentMedian || newWindowValue >= currentMedian) && (nowObsoleteWindowValue <= currentMedian || newWindowValue <= currentMedian)) {
                                currentMedian = BoxesRunTime.unboxToFloat((Object)quickSelectImpl$.MODULE$.apply(tempDataExtract, BoxesRunTime.boxToInteger((int)halfWindow), quickSelectImpl$.MODULE$.impl_Float()));
                            }
                        }
                        ((float[])tempret.elem)[index] = currentMedian;
                        ++index;
                    }
                    OptOverhang optOverhang3 = overhang;
                    if (OptOverhang$PreserveLength$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mFc$sp((float[])tempret.elem);
                    } else if (OptOverhang$None$.MODULE$.equals(optOverhang3)) {
                        vector2 = DenseVector$.MODULE$.apply$mFc$sp((float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps((float[])tempret.elem)).slice(halfWindow, data.length() - halfWindow));
                    } else {
                        throw new MatchError((Object)optOverhang3);
                    }
                    vector = vector2;
                }
                return vector;
            }

            private void findAndReplaceInstanceInPlace(float[] arr, float fromValue, float toValue, int pivotPoint) {
                float pivotValue = arr[pivotPoint];
                boolean found = false;
                if (fromValue == pivotValue) {
                    arr[pivotPoint] = toValue;
                    found = true;
                } else if (fromValue < pivotValue) {
                    int count = pivotPoint - 1;
                    while (count >= 0) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MIN_VALUE;
                            found = true;
                            continue;
                        }
                        --count;
                    }
                } else {
                    int count = pivotPoint + 1;
                    while (count < arr.length) {
                        if (arr[count] == fromValue) {
                            arr[count] = toValue;
                            count = Integer.MAX_VALUE;
                            found = true;
                            continue;
                        }
                        ++count;
                    }
                }
                Predef$.MODULE$.require(found, (Function0 & Serializable & scala.Serializable)() -> "The fromValue was not found within the given array, something is wrong!");
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$apply$16(), $anonfun$apply$17(), $anonfun$apply$18(), $anonfun$apply$19(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$apply$20(breeze.linalg.DenseVector scala.runtime.ObjectRef int ), $anonfun$findAndReplaceInstanceInPlace$4()}, serializedLambda);
            }
        };
    }

    private CanFilterMedian$() {
        MODULE$ = this;
    }
}

