/*
 * Decompiled with CFR 0.152.
 */
package org.scalatest.junit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.scalatest.Reporter;
import org.scalatest.Resources$;
import org.scalatest.ScalaTestStatefulStatus;
import org.scalatest.Suite$;
import org.scalatest.Tracker;
import org.scalatest.events.Formatter;
import org.scalatest.events.IndentedText;
import org.scalatest.events.Location;
import org.scalatest.events.MotionToSuppress$;
import org.scalatest.events.RecordableEvent;
import org.scalatest.events.SeeStackDepthException$;
import org.scalatest.events.TestFailed;
import org.scalatest.events.TestFailed$;
import org.scalatest.events.TestIgnored;
import org.scalatest.events.TestIgnored$;
import org.scalatest.events.TestStarting;
import org.scalatest.events.TestStarting$;
import org.scalatest.events.TestSucceeded;
import org.scalatest.events.TestSucceeded$;
import org.scalatest.events.TopOfMethod;
import org.scalatest.exceptions.PayloadField;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.Tuple3;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Eb!B\u0001\u0003\u0001\tA!!D'z%VtG*[:uK:,'O\u0003\u0002\u0004\t\u0005)!.\u001e8ji*\u0011QAB\u0001\ng\u000e\fG.\u0019;fgRT\u0011aB\u0001\u0004_J<7c\u0001\u0001\n%A\u0011!\u0002E\u0007\u0002\u0017)\u0011A\"D\u0001\r]>$\u0018NZ5dCRLwN\u001c\u0006\u0003\u001d=\taA];o]\u0016\u0014(BA\u0002\u0007\u0013\t\t2BA\u0006Sk:d\u0015n\u001d;f]\u0016\u0014\bCA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"aC*dC2\fwJ\u00196fGRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IaG\u0001\u0007e\u0016\u0004xN\u001d;\u0004\u0001A\u0011A$H\u0007\u0002\t%\u0011a\u0004\u0002\u0002\t%\u0016\u0004xN\u001d;fe\"A\u0001\u0005\u0001B\u0001B\u0003%\u0011%\u0001\u0004d_:4\u0017n\u001a\t\u0005E\u0015B3F\u0004\u0002\u0014G%\u0011A\u0005F\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#aA'ba*\u0011A\u0005\u0006\t\u0003E%J!AK\u0014\u0003\rM#(/\u001b8h!\t\u0019B&\u0003\u0002.)\t\u0019\u0011I\\=\t\u0011=\u0002!\u0011!Q\u0001\nA\n!\u0002\u001e5f)J\f7m[3s!\ta\u0012'\u0003\u00023\t\t9AK]1dW\u0016\u0014\b\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\u0002\rM$\u0018\r^;t!\tab'\u0003\u00028\t\t92kY1mCR+7\u000f^*uCR,g-\u001e7Ti\u0006$Xo\u001d\u0005\u0006s\u0001!\tAO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bmjdh\u0010!\u0011\u0005q\u0002Q\"\u0001\u0002\t\u000beA\u0004\u0019A\u000e\t\u000b\u0001B\u0004\u0019A\u0011\t\u000b=B\u0004\u0019\u0001\u0019\t\u000bQB\u0004\u0019A\u001b\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006Ya-Y5mK\u0012$Vm\u001d;t+\u0005!\u0005cA#KQ5\taI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\u0007M+G\u000f\u0003\u0004N\u0001\u0001\u0006I\u0001R\u0001\rM\u0006LG.\u001a3UKN$8\u000f\t\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u000fO\u0016$Hk\u001c9PM6+G\u000f[8e)\r\t&\f\u0018\t\u0004'I#\u0016BA*\u0015\u0005\u0011\u0019v.\\3\u0011\u0005UCV\"\u0001,\u000b\u0005]#\u0011AB3wK:$8/\u0003\u0002Z-\nYAk\u001c9PM6+G\u000f[8e\u0011\u0015Yf\n1\u0001)\u0003%\u0019G.Y:t\u001d\u0006lW\rC\u0003^\u001d\u0002\u0007\u0001&\u0001\u0006nKRDw\u000e\u001a(b[\u0016DQa\u0018\u0001\u0005B\u0001\f1\u0002^3ti\u001a\u000b\u0017\u000e\\;sKR\u0011\u0011\r\u001a\t\u0003'\tL!a\u0019\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Kz\u0003\rAZ\u0001\bM\u0006LG.\u001e:f!\tQq-\u0003\u0002i\u0017\t9a)Y5mkJ,\u0007\"\u00026\u0001\t\u0003Z\u0017\u0001\u0004;fgR4\u0015N\\5tQ\u0016$GCA1m\u0011\u0015i\u0017\u000e1\u0001o\u0003-!Wm]2sSB$\u0018n\u001c8\u0011\u0005=\u0004X\"A\u0007\n\u0005El!a\u0003#fg\u000e\u0014\u0018\u000e\u001d;j_:DQa\u001d\u0001\u0005BQ\f1\u0002^3ti&;gn\u001c:fIR\u0011\u0011-\u001e\u0005\u0006[J\u0004\rA\u001c\u0005\u0006o\u0002!\t\u0005_\u0001\u0010i\u0016\u001cHOU;o\r&t\u0017n\u001d5fIR\u0011\u0011-\u001f\u0005\u0006uZ\u0004\ra_\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0005=d\u0018BA?\u000e\u0005\u0019\u0011Vm];mi\"1q\u0010\u0001C!\u0003\u0003\ta\u0002^3tiJ+hn\u0015;beR,G\rF\u0002b\u0003\u0007AQ!\u001c@A\u00029Dq!a\u0002\u0001\t\u0003\nI!A\u0006uKN$8\u000b^1si\u0016$GcA1\u0002\f!1Q.!\u0002A\u00029D\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\u00021Q+5\u000bV0E\u000bN\u001b%+\u0013)U\u0013>su\fU!U)\u0016\u0013f*\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001b\t\t9BC\u0002\u0002\u001a\u0019\u000bQA]3hKbLA!!\b\u0002\u0018\t9\u0001+\u0019;uKJt\u0007\u0002CA\u0011\u0001\u0001\u0006I!a\u0005\u00023Q+5\u000bV0E\u000bN\u001b%+\u0013)U\u0013>su\fU!U)\u0016\u0013f\n\t\u0005\b\u0003K\u0001A\u0011BA\u0014\u0003Q\u0001\u0018M]:f)\u0016\u001cH\u000fR3tGJL\u0007\u000f^5p]R!\u0011\u0011FA\u0018!\u0019\u0019\u00121\u0006\u0015)Q%\u0019\u0011Q\u0006\u000b\u0003\rQ+\b\u000f\\34\u0011\u0019i\u00171\u0005a\u0001]\u0002")
public class MyRunListener
extends RunListener
implements ScalaObject {
    private final Reporter report;
    private final Tracker theTracker;
    private final ScalaTestStatefulStatus status;
    private final Set<String> failedTests;
    private final Pattern TEST_DESCRIPTION_PATTERN;

    public Set<String> failedTests() {
        return this.failedTests;
    }

    public Some<TopOfMethod> getTopOfMethod(String className, String methodName) {
        return new Some((Object)new TopOfMethod(className, new StringBuilder().append((Object)"public void ").append((Object)className).append((Object)".").append((Object)methodName).append((Object)"()").toString()));
    }

    public void testFailure(Failure failure) {
        this.failedTests().add(failure.getDescription().getDisplayName());
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(failure.getDescription());
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            Throwable throwableOrNull = failure.getException();
            None$ throwable = throwableOrNull == null ? None$.MODULE$ : new Some((Object)throwableOrNull);
            String message = throwableOrNull == null ? Resources$.MODULE$.apply("jUnitTestFailed") : throwableOrNull.toString();
            IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName, 1, true);
            None$ none$ = throwable;
            Option<Object> payload = none$ instanceof Option && none$ instanceof PayloadField ? ((PayloadField)none$).payload() : None$.MODULE$;
            this.report.apply(new TestFailed(this.theTracker.nextOrdinal(), message, testClassName, testClass, (Option<String>)new Some((Object)testClass), testName, testName, (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Throwable>)throwable, (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)new Some((Object)SeeStackDepthException$.MODULE$), (Option<String>)None$.MODULE$, payload, TestFailed$.MODULE$.apply$default$15(), TestFailed$.MODULE$.apply$default$16()));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testFinished(Description description) {
        Tuple3<String, String, String> tuple3;
        block4: {
            block3: {
                block2: {
                    if (!this.failedTests().contains(description.getDisplayName())) break block2;
                    this.status.setFailed();
                    break block3;
                }
                tuple3 = this.parseTestDescription(description);
                if (tuple3 == null) break block4;
                Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
                String testName = (String)tuple32._1();
                String testClass = (String)tuple32._2();
                String testClassName = (String)tuple32._3();
                IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName, 1, true);
                this.report.apply(new TestSucceeded(this.theTracker.nextOrdinal(), testClassName, testClass, (Option<String>)new Some((Object)testClass), testName, testName, (IndexedSeq<RecordableEvent>)package$.MODULE$.Vector().empty(), (Option<Object>)None$.MODULE$, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass, testName), (Option<String>)TestSucceeded$.MODULE$.apply$default$11(), (Option<Object>)TestSucceeded$.MODULE$.apply$default$12(), TestSucceeded$.MODULE$.apply$default$13(), TestSucceeded$.MODULE$.apply$default$14()));
            }
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testIgnored(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            IndentedText formatter = Suite$.MODULE$.getIndentedTextForTest(testName, 1, true);
            this.report.apply(new TestIgnored(this.theTracker.nextOrdinal(), testClassName, testClass, (Option<String>)new Some((Object)testClass), testName, testName, (Option<Formatter>)new Some((Object)formatter), (Option<Location>)this.getTopOfMethod(testClass, testName), (Option<Object>)TestIgnored$.MODULE$.apply$default$9(), TestIgnored$.MODULE$.apply$default$10(), TestIgnored$.MODULE$.apply$default$11()));
            return;
        }
        throw new MatchError(tuple3);
    }

    public void testRunFinished(Result result) {
    }

    public void testRunStarted(Description description) {
    }

    public void testStarted(Description description) {
        Tuple3<String, String, String> tuple3 = this.parseTestDescription(description);
        if (tuple3 != null) {
            Tuple3 tuple32 = new Tuple3(tuple3._1(), tuple3._2(), tuple3._3());
            String testName = (String)tuple32._1();
            String testClass = (String)tuple32._2();
            String testClassName = (String)tuple32._3();
            this.report.apply(new TestStarting(this.theTracker.nextOrdinal(), testClassName, testClass, (Option<String>)new Some((Object)testClass), testName, testName, (Option<Formatter>)new Some((Object)MotionToSuppress$.MODULE$), (Option<Location>)this.getTopOfMethod(testClass, testName), (Option<String>)TestStarting$.MODULE$.apply$default$9(), (Option<Object>)TestStarting$.MODULE$.apply$default$10(), TestStarting$.MODULE$.apply$default$11(), TestStarting$.MODULE$.apply$default$12()));
            return;
        }
        throw new MatchError(tuple3);
    }

    public Pattern TEST_DESCRIPTION_PATTERN() {
        return this.TEST_DESCRIPTION_PATTERN;
    }

    private Tuple3<String, String, String> parseTestDescription(Description description) {
        Matcher matcher = this.TEST_DESCRIPTION_PATTERN().matcher(description.getDisplayName());
        if (matcher.find()) {
            String testName = matcher.group(1);
            String testClass = matcher.group(2);
            String testClassName = testClass.replaceAll(".*\\.", "");
            return new Tuple3((Object)testName, (Object)testClass, (Object)testClassName);
        }
        throw new RuntimeException(new StringBuilder().append((Object)"unexpected displayName [").append((Object)description.getDisplayName()).append((Object)"]").toString());
    }

    public MyRunListener(Reporter report, Map<String, Object> config, Tracker theTracker, ScalaTestStatefulStatus status) {
        this.report = report;
        this.theTracker = theTracker;
        this.status = status;
        this.failedTests = Collections.synchronizedSet(new HashSet());
        this.TEST_DESCRIPTION_PATTERN = Pattern.compile("^(.*)\\((.*)\\)");
    }
}

