/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.clients.ReservationSummary;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class GroupByHaving {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            GroupByHaving.groupBy(entityManager);
            GroupByHaving.having(entityManager);
            entityManager.getTransaction().commit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            entityManager.close();
            factory.close();
        }
    }

    public static void groupBy(EntityManager manager) {
        System.out.println("GROUP BY Clause");
        System.out.println("--------------------------------");
        System.out.println("SELECT new com.titan.clients.ReservationSummary(cr.name, COUNT(res), SUM(res.amountPaid))");
        System.out.println("FROM Cruise cr");
        System.out.println("LEFT JOIN cr.reservations res");
        System.out.println("GROUP BY cr.name");
        Query query = manager.createQuery("SELECT new com.titan.clients.ReservationSummary(cr.name, COUNT(res), SUM(res.amountPaid)) FROM Cruise cr LEFT JOIN cr.reservations res GROUP BY cr.name");
        List summaries = query.getResultList();
        for (ReservationSummary summary : summaries) {
            System.out.println("   " + summary.cruise + ": " + summary.numReservations + "   " + summary.cashflow);
        }
    }

    public static void having(EntityManager manager) {
        System.out.println("GROUP BY Clause");
        System.out.println("--------------------------------");
        System.out.println("SELECT new com.titan.clients.ReservationSummary(cr.name, COUNT(res), SUM(res.amountPaid))");
        System.out.println("FROM Cruise cr");
        System.out.println("LEFT JOIN cr.reservations res");
        System.out.println("GROUP BY cr.name");
        System.out.println("HAVING count(res) > 1");
        Query query = manager.createQuery("SELECT new com.titan.clients.ReservationSummary(cr.name, COUNT(res), SUM(res.amountPaid)) FROM Cruise cr LEFT JOIN cr.reservations res GROUP BY cr.name HAVING count(res) > 1");
        List summaries = query.getResultList();
        for (ReservationSummary summary : summaries) {
            System.out.println("   " + summary.cruise + ": " + summary.numReservations + "   " + summary.cashflow);
        }
    }
}

