/*
 * Decompiled with CFR 0.152.
 */
package com.titan.clients;

import com.titan.clients.InitializeDB;
import com.titan.domain.Name;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;

public class SelectClause {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        HashMap map = new HashMap();
        EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)"titan", map);
        EntityManager entityManager = factory.createEntityManager();
        entityManager.getTransaction().begin();
        try {
            System.out.println("Initialize DB");
            InitializeDB.initialize(entityManager);
            System.out.println();
            System.out.println();
            SelectClause.columnResultSet(entityManager);
            System.out.println();
            System.out.println();
            SelectClause.nestedRelationshipPropertyResultSet(entityManager);
            System.out.println();
            System.out.println();
            SelectClause.constructorExpression(entityManager);
            System.out.println();
            System.out.println();
        }
        finally {
            entityManager.getTransaction().commit();
            entityManager.close();
            factory.close();
        }
    }

    public static void columnResultSet(EntityManager entityManager) {
        System.out.println("Executing query: ");
        System.out.println("SELECT c.firstName, c.lastName FROM Customer AS c");
        Query query = entityManager.createQuery("SELECT c.firstName, c.lastName FROM Customer AS c");
        List list = query.getResultList();
        for (Object[] result : list) {
            System.out.println("\t" + result[0] + " " + result[1]);
        }
    }

    public static void nestedRelationshipPropertyResultSet(EntityManager entityManager) {
        System.out.println("Executing query: ");
        System.out.println("SELECT c.creditCard.creditCompany.address.city FROM Customer AS c");
        Query query = entityManager.createQuery("SELECT c.creditCard.creditCompany.address.city FROM Customer AS c");
        List list = query.getResultList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            System.out.println("\t" + it.next());
        }
    }

    public static void constructorExpression(EntityManager entityManager) {
        System.out.println("Executing query: ");
        System.out.println("SELECT new com.titan.domain.Name(c.firstName, c.lastName) FROM Customer c");
        Query query = entityManager.createQuery("SELECT new com.titan.domain.Name(c.firstName, c.lastName) FROM Customer c");
        List list = query.getResultList();
        for (Name result : list) {
            System.out.println("\t" + result.getFirst() + " " + result.getLast());
        }
    }
}

