/*
 * Decompiled with CFR 0.152.
 */
package org.scoverage.plugin;

import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.scoverage.plugin.SCoverageForkedLifecycleConfigurator;

@Mojo(name="package", threadSafe=true)
@Execute(lifecycle="scoverage", phase=LifecyclePhase.PACKAGE)
public class SCoveragePackageMojo
extends AbstractMojo {
    @Parameter(property="scoverage.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    private List<MavenProject> reactorProjects;

    public void execute() {
        if ("pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping SCoverage execution for project with packaging type 'pom'");
            return;
        }
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping Scoverage execution");
            return;
        }
        long ts = System.currentTimeMillis();
        SCoverageForkedLifecycleConfigurator.afterForkedLifecycleExit(this.project, this.reactorProjects);
        long te = System.currentTimeMillis();
        this.getLog().debug((CharSequence)String.format("Mojo execution time: %d ms", te - ts));
    }
}

