/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.parse;

import java.io.File;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.FileContent;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;

public class ParseCommand
implements Command {
    private Journal _journal = null;
    private ProtocolParserManager _protocolParserManager = null;

    public void setJournal(Journal journal) {
        this._journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this._protocolParserManager = parser;
    }

    public String getName() {
        return "parse";
    }

    public String getDescription() {
        return "Parse a Scribble description";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 1) {
            this._journal.info("PARSE " + args[0], null);
            File f = new File(args[0]);
            if (!f.exists()) {
                this._journal.error("File not found '" + args[0] + "'", null);
            } else {
                try {
                    FileContent content = new FileContent(f);
                    ProtocolModel pm = this._protocolParserManager.parse(null, (Content)content, this._journal);
                    if (pm == null) {
                        this._journal.error("Protocol Model is null", null);
                    }
                    ret = true;
                }
                catch (Exception e) {
                    this._journal.error("Failed to parse file '" + args[0] + "'", null);
                }
            }
        } else {
            this._journal.error("Parser expects 1 parameter", null);
        }
        return ret;
    }
}

