/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.project;

import java.io.File;
import java.io.OutputStream;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.FileContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolTools;
import org.scribble.protocol.ProtocolTools;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.projection.ProtocolProjector;

public class ProjectCommand
implements Command {
    private Journal _journal = null;
    private ProtocolParserManager _protocolParserManager = null;
    private ProtocolProjector _protocolProjector = null;
    private ProtocolExportManager _protocolExportManager = null;

    public void setJournal(Journal journal) {
        this._journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this._protocolParserManager = parser;
    }

    public void setProtocolProjector(ProtocolProjector projector) {
        this._protocolProjector = projector;
    }

    public void setProtocolExportManager(ProtocolExportManager exportManager) {
        this._protocolExportManager = exportManager;
    }

    public String getName() {
        return "project";
    }

    public String getDescription() {
        return "Project a global protocol description to a role's local model";
    }

    public boolean execute(String[] args) {
        boolean ret;
        block10: {
            ret = false;
            if (args.length == 2) {
                this._journal.info("PROJECT " + args[0] + " for role " + args[1], null);
                File f = new File(args[0]);
                if (!f.exists()) {
                    this._journal.error("File not found '" + args[0] + "'", null);
                } else {
                    ProtocolModel model = null;
                    try {
                        FileContent content = new FileContent(f);
                        model = this._protocolParserManager.parse((ProtocolTools)new DefaultProtocolTools(this._protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f.getParentFile())), (Content)content, this._journal);
                    }
                    catch (Exception e) {
                        this._journal.error("Failed to parse file '" + args[0] + "'", null);
                    }
                    if (model != null) {
                        Role role = new Role(args[1]);
                        try {
                            DefaultProtocolTools context = new DefaultProtocolTools(this._protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f.getParentFile()));
                            ProtocolModel projection = this._protocolProjector.project((ProtocolTools)context, model, role, this._journal);
                            if (projection == null) break block10;
                            ProtocolExporter exporter = this._protocolExportManager.getExporter("txt");
                            if (exporter != null) {
                                exporter.export(projection, this._journal, (OutputStream)System.out);
                                ret = true;
                                break block10;
                            }
                            this._journal.error("Unable to find text exporter", null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                this._journal.error("Projection expects 2 parameters", null);
            }
        }
        return ret;
    }
}

