/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.validate;

import java.io.File;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.Content;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.FileContent;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolTools;
import org.scribble.protocol.ProtocolTools;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.projection.ProtocolProjector;
import org.scribble.protocol.validation.ProtocolValidationManager;

public class ValidateCommand
implements Command {
    private ProtocolValidationManager _validationManager = null;
    private Journal _journal = null;
    private ProtocolParserManager _protocolParserManager = null;
    private ProtocolProjector _protocolProjector = null;

    public void setValidationManager(ProtocolValidationManager vm) {
        this._validationManager = vm;
    }

    public void setJournal(Journal journal) {
        this._journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this._protocolParserManager = parser;
    }

    public void setProtocolProjector(ProtocolProjector projector) {
        this._protocolProjector = projector;
    }

    public String getName() {
        return "validate";
    }

    public String getDescription() {
        return "Validate a Scribble description";
    }

    public boolean execute(String[] args) {
        boolean ret;
        block7: {
            ret = false;
            if (args.length == 1) {
                this._journal.info("PARSE " + args[0], null);
                File f = new File(args[0]);
                if (!f.exists()) {
                    this._journal.error("File not found '" + args[0] + "'", null);
                } else {
                    try {
                        FileContent content = new FileContent(f);
                        DefaultProtocolTools context = new DefaultProtocolTools(this._protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f.getParentFile()));
                        context.setProtocolValidationManager(this._validationManager);
                        context.setProtocolProjector(this._protocolProjector);
                        ProtocolModel model = this._protocolParserManager.parse((ProtocolTools)context, (Content)content, this._journal);
                        if (model != null) {
                            this._journal.info("VALIDATE " + args[0], null);
                            this._validationManager.validate((ProtocolTools)context, model, this._journal);
                            ret = true;
                            break block7;
                        }
                        this._journal.error("Protocol model is null", null);
                    }
                    catch (Exception e) {
                        this._journal.error("Failed to validate file '" + args[0] + "'", null);
                    }
                }
            } else {
                System.err.println("Validation expecting 1 parameter");
            }
        }
        return ret;
    }
}

