/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.common.logging;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.common.logging.Journal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedJournal
implements Journal {
    private List<IssueDetails> m_issues = new Vector<IssueDetails>();
    private boolean f_errors = false;
    private boolean f_warnings = false;

    @Override
    public void error(String issue, Map<String, Object> props) {
        this.m_issues.add(new IssueDetails(IssueType.Error, issue, props));
        this.f_errors = true;
    }

    @Override
    public void info(String issue, Map<String, Object> props) {
        this.m_issues.add(new IssueDetails(IssueType.Info, issue, props));
    }

    @Override
    public void warning(String issue, Map<String, Object> props) {
        this.m_issues.add(new IssueDetails(IssueType.Warning, issue, props));
        this.f_warnings = true;
    }

    public List<IssueDetails> getIssues() {
        return this.m_issues;
    }

    public boolean hasErrors() {
        return this.f_errors;
    }

    public boolean hasWarnings() {
        return this.f_warnings;
    }

    public void apply(Journal logger) {
        for (IssueDetails id : this.m_issues) {
            if (id.getIssueType() == IssueType.Error) {
                logger.error(id.getMessage(), id.getProperties());
                continue;
            }
            if (id.getIssueType() == IssueType.Info) {
                logger.info(id.getMessage(), id.getProperties());
                continue;
            }
            if (id.getIssueType() != IssueType.Warning) continue;
            logger.warning(id.getMessage(), id.getProperties());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class IssueDetails {
        private IssueType m_type = IssueType.Info;
        private String m_message = null;
        private Map<String, Object> m_properties = null;

        public IssueDetails(IssueType type, String mesg, Map<String, Object> props) {
            this.m_type = type;
            this.m_message = mesg;
            this.m_properties = props;
        }

        public IssueType getIssueType() {
            return this.m_type;
        }

        public String getMessage() {
            return this.m_message;
        }

        public Map<String, Object> getProperties() {
            return this.m_properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IssueType {
        Error,
        Info,
        Warning;

    }
}

