/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.conformance.impl.rules;

import java.util.HashMap;
import java.util.Map;
import org.scribble.protocol.conformance.ConformanceHandler;
import org.scribble.protocol.conformance.impl.rules.ConformanceRule;
import org.scribble.protocol.conformance.impl.rules.InteractionConformanceRule;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConformanceRuleManager {
    private static final Map<Class<? extends ModelObject>, ConformanceRule<? extends ModelObject>> RULES = new HashMap<Class<? extends ModelObject>, ConformanceRule<? extends ModelObject>>();

    private ConformanceRuleManager() {
    }

    public static boolean hasRule(ModelObject modelObject) {
        return RULES.containsKey(modelObject.getClass());
    }

    public static <T extends ModelObject> boolean conforms(T model, T ref, ConformanceHandler handler) {
        boolean ret = false;
        ConformanceRule<? extends ModelObject> rule = RULES.get(model.getClass());
        if (rule != null) {
            ret = rule.conforms(model, ref, handler);
        }
        return ret;
    }

    static {
        RULES.put(Interaction.class, new InteractionConformanceRule());
    }
}

