/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.monitor;

import org.scribble.protocol.monitor.Message;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.monitor.Result;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Call;
import org.scribble.protocol.monitor.model.ChoiceNode;
import org.scribble.protocol.monitor.model.DecisionNode;
import org.scribble.protocol.monitor.model.Description;
import org.scribble.protocol.monitor.model.MessageNode;
import org.scribble.protocol.monitor.model.Node;
import org.scribble.protocol.monitor.model.ParallelNode;
import org.scribble.protocol.monitor.model.Path;
import org.scribble.protocol.monitor.model.ReceiveChoice;
import org.scribble.protocol.monitor.model.ReceiveDecision;
import org.scribble.protocol.monitor.model.ReceiveMessage;
import org.scribble.protocol.monitor.model.Scope;
import org.scribble.protocol.monitor.model.SendChoice;
import org.scribble.protocol.monitor.model.SendDecision;
import org.scribble.protocol.monitor.model.SendMessage;
import org.scribble.protocol.monitor.model.TryNode;

public class DefaultProtocolMonitor
implements ProtocolMonitor {
    public void initialize(MonitorContext context, Description protocol, Session conv) {
        if (protocol.getNode().size() > 0) {
            this.addNodeToConversation(context, protocol, conv, 0);
        }
    }

    public Result messageSent(MonitorContext context, Description protocol, Session conv, String role, Message mesg) {
        int i;
        Result ret = Result.NOT_HANDLED;
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNumberOfNodeIndexes(); ++i) {
            ret = this.checkForSendMessage(context, protocol, i, conv.getNodeIndexAt(i), conv, role, mesg);
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNestedConversations().size(); ++i) {
            Session nested = conv.getNestedConversations().get(i);
            ret = this.messageSent(context, protocol, nested, role, mesg);
            if (!ret.isValid()) continue;
            if (nested.getMainConversation() != null) {
                Session main = nested.getMainConversation();
                if (conv.getNestedConversations().remove(main)) {
                    for (Session cc : main.getCatchConversations()) {
                        if (cc == nested) continue;
                        conv.getNestedConversations().remove(cc);
                    }
                }
            }
            if (!nested.isFinished()) continue;
            this.nestedConversationFinished(context, protocol, conv, nested);
        }
        return ret;
    }

    protected Result checkForSendMessage(MonitorContext context, Description protocol, int pos, int nodeIndex, Session conv, String role, Message mesg) {
        Result ret = Result.NOT_HANDLED;
        Node node = protocol.getNode().get(nodeIndex);
        if (node instanceof SendMessage) {
            ret = this.checkMessage(context, conv, (SendMessage)node, role, mesg);
            if (ret.isValid()) {
                conv.removeNodeIndexAt(pos);
                if (node.getNextIndex() != -1) {
                    this.addNodeToConversation(context, protocol, conv, node.getNextIndex());
                }
            }
        } else if (node instanceof SendChoice) {
            for (int j = 0; ret == Result.NOT_HANDLED && j < ((SendChoice)node).getPath().size(); ++j) {
                Path cn = ((SendChoice)node).getPath().get(j);
                if (cn.getNextIndex() == -1) continue;
                ret = this.checkForSendMessage(context, protocol, pos, cn.getNextIndex(), conv, role, mesg);
            }
        } else if (node instanceof SendDecision) {
            if (((SendDecision)node).getInnerIndex() != -1) {
                ret = this.checkForSendMessage(context, protocol, pos, ((SendDecision)node).getInnerIndex(), conv, role, mesg);
            }
            if (ret == Result.NOT_HANDLED && node.getNextIndex() != -1) {
                ret = this.checkForSendMessage(context, protocol, pos, node.getNextIndex(), conv, role, mesg);
            }
        }
        return ret;
    }

    public Result messageReceived(MonitorContext context, Description protocol, Session conv, String role, Message mesg) {
        int i;
        Result ret = Result.NOT_HANDLED;
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNumberOfNodeIndexes(); ++i) {
            ret = this.checkForReceiveMessage(context, protocol, i, conv.getNodeIndexAt(i), conv, role, mesg);
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNestedConversations().size(); ++i) {
            Session nested = conv.getNestedConversations().get(i);
            ret = this.messageReceived(context, protocol, nested, role, mesg);
            if (!ret.isValid()) continue;
            if (nested.getMainConversation() != null) {
                Session main = nested.getMainConversation();
                if (conv.getNestedConversations().remove(main)) {
                    for (Session cc : main.getCatchConversations()) {
                        if (cc == nested) continue;
                        conv.getNestedConversations().remove(cc);
                    }
                }
            }
            if (!nested.isFinished()) continue;
            this.nestedConversationFinished(context, protocol, conv, nested);
        }
        return ret;
    }

    protected Result checkForReceiveMessage(MonitorContext context, Description protocol, int pos, int nodeIndex, Session conv, String role, Message mesg) {
        Result ret = Result.NOT_HANDLED;
        Node node = protocol.getNode().get(nodeIndex);
        if (node instanceof ReceiveMessage) {
            ret = this.checkMessage(context, conv, (ReceiveMessage)node, role, mesg);
            if (ret.isValid()) {
                conv.removeNodeIndexAt(pos);
                if (node.getNextIndex() != -1) {
                    this.addNodeToConversation(context, protocol, conv, node.getNextIndex());
                }
            }
        } else if (node instanceof ReceiveChoice) {
            for (int j = 0; ret == Result.NOT_HANDLED && j < ((ReceiveChoice)node).getPath().size(); ++j) {
                Path cn = ((ReceiveChoice)node).getPath().get(j);
                if (cn.getNextIndex() == -1) continue;
                ret = this.checkForReceiveMessage(context, protocol, pos, cn.getNextIndex(), conv, role, mesg);
            }
        } else if (node instanceof ReceiveDecision) {
            if (((ReceiveDecision)node).getInnerIndex() != -1) {
                ret = this.checkForReceiveMessage(context, protocol, pos, ((ReceiveDecision)node).getInnerIndex(), conv, role, mesg);
            }
            if (ret == Result.NOT_HANDLED && node.getNextIndex() != -1) {
                ret = this.checkForReceiveMessage(context, protocol, pos, node.getNextIndex(), conv, role, mesg);
            }
        }
        return ret;
    }

    protected Result checkMessage(MonitorContext context, Session conv, MessageNode node, String role, Message sig) {
        Result ret = Result.NOT_HANDLED;
        if ((node.getOtherRole() == null || role == null || node.getOtherRole().equals(role)) && (sig.getOperator() == null || node.getOperator() == null || node.getOperator().equals(sig.getOperator()))) {
            ret = context.validate(node, sig);
        }
        return ret;
    }

    public Result sendChoice(MonitorContext context, Description protocol, Session conv, String role, String label) {
        return this.checkChoice(context, protocol, conv, role, label, true);
    }

    public Result receiveChoice(MonitorContext context, Description protocol, Session conv, String role, String label) {
        return this.checkChoice(context, protocol, conv, role, label, false);
    }

    protected Result checkChoice(MonitorContext context, Description protocol, Session conv, String role, String label, boolean send) {
        int i;
        Result ret = Result.NOT_HANDLED;
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNumberOfNodeIndexes(); ++i) {
            Node node = protocol.getNode().get(conv.getNodeIndexAt(i));
            if ((!(node instanceof SendChoice) || !send) && (!(node instanceof ReceiveChoice) || send)) continue;
            ChoiceNode choiceNode = (ChoiceNode)node;
            for (int j = 0; ret == Result.NOT_HANDLED && j < choiceNode.getPath().size(); ++j) {
                Path cn = choiceNode.getPath().get(j);
                if (!cn.getId().equals(label)) continue;
                ret = Result.VALID;
                conv.removeNodeIndexAt(i);
                if (cn.getNextIndex() == -1) continue;
                this.addNodeToConversation(context, protocol, conv, cn.getNextIndex());
            }
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNestedConversations().size(); ++i) {
            Session nested = conv.getNestedConversations().get(i);
            ret = this.checkChoice(context, protocol, nested, role, label, send);
            if (!ret.isValid() || !nested.isFinished()) continue;
            this.nestedConversationFinished(context, protocol, conv, nested);
        }
        return ret;
    }

    public Result sendDecision(MonitorContext context, Description protocol, Session conv, String role, boolean bool) {
        return this.checkDecision(context, protocol, conv, role, bool, true);
    }

    public Result receiveDecision(MonitorContext context, Description protocol, Session conv, String role, boolean bool) {
        return this.checkDecision(context, protocol, conv, role, bool, false);
    }

    protected Result checkDecision(MonitorContext context, Description protocol, Session conv, String role, boolean bool, boolean send) {
        int i;
        Result ret = Result.NOT_HANDLED;
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNumberOfNodeIndexes(); ++i) {
            Node node = protocol.getNode().get(conv.getNodeIndexAt(i));
            if ((!(node instanceof SendDecision) || !send) && (!(node instanceof ReceiveDecision) || send)) continue;
            int index = node.getNextIndex();
            if (bool) {
                index = ((DecisionNode)node).getInnerIndex();
            }
            if (index != -1) {
                this.addNodeToConversation(context, protocol, conv, index);
            }
            conv.removeNodeIndexAt(i);
            ret = Result.VALID;
        }
        for (i = 0; ret == Result.NOT_HANDLED && i < conv.getNestedConversations().size(); ++i) {
            Session nested = conv.getNestedConversations().get(i);
            ret = this.checkDecision(context, protocol, nested, role, bool, send);
            if (!ret.isValid() || !nested.isFinished()) continue;
            this.nestedConversationFinished(context, protocol, conv, nested);
        }
        return ret;
    }

    protected void addNodeToConversation(MonitorContext context, Description protocol, Session conv, int nodeIndex) {
        Node node = protocol.getNode().get(nodeIndex);
        if (node.getClass() == Scope.class) {
            this.initScope(context, protocol, conv, (Scope)node);
        } else if (node.getClass() == TryNode.class) {
            Session nested = this.initScope(context, protocol, conv, (TryNode)node);
            for (int ci : ((TryNode)node).getCatchIndex()) {
                if (ci == -1) continue;
                Session catchScope = conv.createCatchConversation(nested, node.getNextIndex());
                catchScope.addNodeIndex(ci);
            }
        } else if (node.getClass() == Call.class) {
            if (((Call)node).getCallIndex() != -1) {
                this.addNodeToConversation(context, protocol, conv, ((Call)node).getCallIndex());
            }
            if (node.getNextIndex() != -1) {
                this.addNodeToConversation(context, protocol, conv, node.getNextIndex());
            }
        } else if (node.getClass() == ParallelNode.class) {
            if (node.getNextIndex() != -1) {
                Session nestedContext = conv.createNestedConversation(node.getNextIndex());
                ParallelNode pnode = (ParallelNode)node;
                for (Path path : pnode.getPath()) {
                    if (path.getNextIndex() == -1) continue;
                    this.addNodeToConversation(context, protocol, nestedContext, path.getNextIndex());
                }
            }
        } else {
            conv.addNodeIndex(nodeIndex);
        }
    }

    protected Session initScope(MonitorContext context, Description protocol, Session conv, Scope scope) {
        Session nestedContext = null;
        if (scope.getInnerIndex() != -1) {
            nestedContext = conv.createNestedConversation(scope.getNextIndex());
            this.addNodeToConversation(context, protocol, nestedContext, scope.getInnerIndex());
        } else {
            System.err.println("EXTERNAL PROTOCOL MONITORING NOT CURRENTLY SUPPORTED");
        }
        return nestedContext;
    }

    protected void nestedConversationFinished(MonitorContext context, Description protocol, Session conv, Session nested) {
        if (nested.getReturnIndex() != -1) {
            this.addNodeToConversation(context, protocol, conv, nested.getReturnIndex());
        }
        conv.removeNestedConversation(nested);
        for (Session cc : nested.getCatchConversations()) {
            conv.removeNestedConversation(cc);
        }
    }
}

