/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.monitor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Vector;
import org.scribble.protocol.monitor.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSession
implements Session,
Externalizable {
    private List<Integer> m_nodeIndexes = new Vector<Integer>();
    private int m_returnIndex = -1;
    private Session m_mainConversation = null;
    private List<Session> m_nestedConversations = new Vector<Session>();
    private List<Session> m_catchConversations = new Vector<Session>();

    public DefaultSession() {
    }

    protected DefaultSession(int returnIndex) {
        this.m_returnIndex = returnIndex;
    }

    protected DefaultSession(Session main, int returnIndex) {
        this.m_mainConversation = main;
        this.m_returnIndex = returnIndex;
    }

    @Override
    public void addNodeIndex(int index) {
        this.m_nodeIndexes.add(index);
    }

    @Override
    public void removeNodeIndexAt(int pos) {
        this.m_nodeIndexes.remove(pos);
    }

    @Override
    public int getNumberOfNodeIndexes() {
        return this.m_nodeIndexes.size();
    }

    @Override
    public int getNodeIndexAt(int pos) {
        return this.m_nodeIndexes.get(pos);
    }

    @Override
    public boolean isFinished() {
        return this.m_nodeIndexes.size() == 0 && this.m_nestedConversations.size() == 0;
    }

    @Override
    public Session createNestedConversation(int returnIndex) {
        DefaultSession ret = new DefaultSession(returnIndex);
        this.m_nestedConversations.add(ret);
        return ret;
    }

    @Override
    public Session createCatchConversation(Session main, int returnIndex) {
        DefaultSession ret = new DefaultSession(main, returnIndex);
        this.m_nestedConversations.add(ret);
        main.getCatchConversations().add(ret);
        return ret;
    }

    @Override
    public int getReturnIndex() {
        return this.m_returnIndex;
    }

    public void setReturnIndex(int returnIndex) {
        this.m_returnIndex = returnIndex;
    }

    @Override
    public List<Session> getNestedConversations() {
        return this.m_nestedConversations;
    }

    @Override
    public void removeNestedConversation(Session context) {
        this.m_nestedConversations.remove(context);
    }

    @Override
    public Session getMainConversation() {
        return this.m_mainConversation;
    }

    @Override
    public List<Session> getCatchConversations() {
        return this.m_catchConversations;
    }

    @Override
    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput arg0) throws IOException {
    }
}

