/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.SubProtocolPath;
import org.scribble.protocol.projection.ProtocolProjector;
import org.scribble.protocol.projection.impl.DefaultProjectorContext;

public class ProtocolProjectorImpl
implements ProtocolProjector {
    public ProtocolModel project(ProtocolModel model, Role role, Journal journal) {
        return this.project(model, null, role, journal);
    }

    public ProtocolModel project(ProtocolModel model, SubProtocolPath subPath, Role role, Journal journal) {
        ProtocolModel ret = null;
        DefaultProjectorContext context = new DefaultProjectorContext(subPath);
        ModelObject obj = context.project((ModelObject)model, role, journal);
        if (obj != null) {
            if (obj instanceof ProtocolModel) {
                ret = (ProtocolModel)obj;
            } else {
                String modelName = model.getProtocol().getName();
                if (model.getProtocol().getRole() != null) {
                    modelName = modelName + "," + model.getProtocol().getRole();
                }
                journal.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.projection.Messages").getString("_NOT_PROJECTED_MODEL"), modelName), null);
            }
        }
        return ret;
    }
}

