/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.List;
import java.util.Vector;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorContext;
import org.scribble.protocol.projection.impl.ProjectorRule;

public class ProtocolProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Protocol.class;
    }

    public ModelObject project(ProjectorContext context, ModelObject model, Role role, Journal l) {
        Protocol ret = null;
        Protocol source = (Protocol)model;
        List<Role> roles = null;
        if (context.isOuterScope() || (roles = context.getRolesOfInterestForDefinition(source)) != null) {
            if (roles == null) {
                roles = new Vector<Role>();
                roles.add(role);
            }
            for (int j = 0; j < roles.size(); ++j) {
                Protocol prot = new Protocol();
                role = roles.get(j);
                prot.derivedFrom((ModelObject)source);
                prot.setName(source.getName());
                Role located = (Role)context.project((ModelObject)role, role, l);
                prot.setRole(located);
                context.pushScope();
                for (ParameterDefinition p : source.getParameterDefinitions()) {
                    ParameterDefinition projp = (ParameterDefinition)context.project((ModelObject)p, role, l);
                    if (projp == null) continue;
                    prot.getParameterDefinitions().add(projp);
                }
                prot.setBlock((Block)context.project((ModelObject)source.getBlock(), role, l));
                prot.getBlock().setParent((ModelObject)prot);
                context.popScope();
                if (ret == null) {
                    ret = prot;
                    continue;
                }
                if (ret instanceof Block) {
                    ((Block)ret).getContents().add(prot);
                    continue;
                }
                Block b = new Block();
                b.getContents().add(ret);
                b.getContents().add(prot);
                ret = b;
            }
        }
        return ret;
    }
}

