/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.List;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;
import org.scribble.protocol.util.ActivityUtil;

public abstract class AbstractBlockProjectorRule
implements ProjectorRule {
    private static final Logger LOG = Logger.getLogger(AbstractBlockProjectorRule.class.getName());

    protected abstract Block createBlock();

    public ModelObject project(ProtocolProjectorContext context, ModelObject model, Role role, Journal l) {
        Block ret = this.createBlock();
        Block source = (Block)model;
        ret.derivedFrom((ModelObject)source);
        context.pushState();
        for (int i = 0; i < source.getContents().size(); ++i) {
            Object act = context.project((ModelObject)source.getContents().get(i), role, l);
            if (act instanceof Activity) {
                ret.getContents().add((Activity)act);
                continue;
            }
            if (!(act instanceof List)) continue;
            for (Object a2 : (List)act) {
                if (a2 instanceof Activity) {
                    ret.getContents().add((Activity)a2);
                    continue;
                }
                LOG.severe("Unexpected element returns from block projection: " + a2);
            }
        }
        context.popState();
        if (this.isFilterOutEmptyContent()) {
            int behaviourCount = 0;
            for (Activity act : ret.getContents()) {
                if (!ActivityUtil.isBehaviour((Activity)act)) continue;
                ++behaviourCount;
            }
            if (behaviourCount == 0) {
                ret = null;
            }
        }
        return ret;
    }

    protected boolean isFilterOutEmptyContent() {
        return true;
    }
}

