/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.BlockProjectorRule;
import org.scribble.protocol.projection.impl.ChoiceProjectorRule;
import org.scribble.protocol.projection.impl.DataTypeProjectorRule;
import org.scribble.protocol.projection.impl.DirectedChoiceProjectorRule;
import org.scribble.protocol.projection.impl.DoProjectorRule;
import org.scribble.protocol.projection.impl.EndProjectorRule;
import org.scribble.protocol.projection.impl.InlineProjectorRule;
import org.scribble.protocol.projection.impl.InteractionProjectorRule;
import org.scribble.protocol.projection.impl.InterruptProjectorRule;
import org.scribble.protocol.projection.impl.IntroducesProjectorRule;
import org.scribble.protocol.projection.impl.MessageSignatureProjectorRule;
import org.scribble.protocol.projection.impl.OnMessageProjectorRule;
import org.scribble.protocol.projection.impl.ParallelProjectorRule;
import org.scribble.protocol.projection.impl.ParameterProjectorRule;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolImportListProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolImportProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolModelProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;
import org.scribble.protocol.projection.impl.ProtocolProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolReferenceProjectorRule;
import org.scribble.protocol.projection.impl.RecBlockProjectorRule;
import org.scribble.protocol.projection.impl.RecursionProjectorRule;
import org.scribble.protocol.projection.impl.RepeatProjectorRule;
import org.scribble.protocol.projection.impl.RoleProjectorRule;
import org.scribble.protocol.projection.impl.RunProjectorRule;
import org.scribble.protocol.projection.impl.Scope;
import org.scribble.protocol.projection.impl.TypeImportListProjectorRule;
import org.scribble.protocol.projection.impl.TypeImportProjectorRule;
import org.scribble.protocol.projection.impl.TypeReferenceProjectorRule;
import org.scribble.protocol.projection.impl.UnorderedProjectorRule;
import org.scribble.protocol.validation.ProtocolValidationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectorContext
implements ProtocolProjectorContext {
    private static Logger logger = Logger.getLogger(DefaultProjectorContext.class.getName());
    private static final List<ProjectorRule> RULES = new Vector<ProjectorRule>();
    private ProtocolContext _context = null;
    private ProtocolValidationManager _pvm = null;
    private Scope _scope = new Scope();
    private List<Scope> _scopeStack = new Vector<Scope>();
    private Map<Protocol, List<Role>> _definitionRoleMap = new HashMap<Protocol, List<Role>>();

    public DefaultProjectorContext(ProtocolContext context, ProtocolValidationManager pvm) {
        this._context = context;
        this._pvm = pvm;
    }

    @Override
    public ProtocolContext getProtocolContext() {
        return this._context;
    }

    @Override
    public ProtocolValidationManager getProtocolValidationManager() {
        return this._pvm;
    }

    @Override
    public Object project(ModelObject model, Role role, Journal l) {
        Object ret = null;
        for (int i = 0; model != null && ret == null && i < this.getRules().size(); ++i) {
            if (!this.getRules().get(i).isSupported(model)) continue;
            ret = this.getRules().get(i).project(this, model, role, l);
        }
        return ret;
    }

    public List<ProjectorRule> getRules() {
        return RULES;
    }

    @Override
    public Object getState(String name) {
        return this._scope.getState(name);
    }

    @Override
    public void setState(String name, Object value) {
        this._scope.setState(name, value);
    }

    @Override
    public void pushState() {
        this._scope.pushState();
    }

    @Override
    public void popState() {
        this._scope.popState();
    }

    @Override
    public void pushScope() {
        this._scopeStack.add(0, this._scope);
        this._scope = new Scope();
    }

    @Override
    public void popScope() {
        if (this._scopeStack.size() > 0) {
            this._scope = this._scopeStack.remove(0);
        } else {
            logger.severe("No state entry to pop from stack");
        }
    }

    @Override
    public boolean isOuterScope() {
        return this._scopeStack.size() < 1;
    }

    @Override
    public void registerInterest(Protocol defn, Role role) {
        List<Role> roles = this._definitionRoleMap.get(defn);
        if (roles == null) {
            roles = new Vector<Role>();
            this._definitionRoleMap.put(defn, roles);
        }
        if (!roles.contains(role)) {
            roles.add(role);
        }
    }

    @Override
    public List<Role> getRolesOfInterestForDefinition(Protocol defn) {
        return this._definitionRoleMap.get(defn);
    }

    static {
        RULES.add(new BlockProjectorRule());
        RULES.add(new InterruptProjectorRule());
        RULES.add(new ChoiceProjectorRule());
        RULES.add(new DirectedChoiceProjectorRule());
        RULES.add(new OnMessageProjectorRule());
        RULES.add(new ProtocolImportListProjectorRule());
        RULES.add(new ProtocolImportProjectorRule());
        RULES.add(new TypeImportListProjectorRule());
        RULES.add(new TypeImportProjectorRule());
        RULES.add(new InteractionProjectorRule());
        RULES.add(new MessageSignatureProjectorRule());
        RULES.add(new ParallelProjectorRule());
        RULES.add(new IntroducesProjectorRule());
        RULES.add(new RoleProjectorRule());
        RULES.add(new ProtocolModelProjectorRule());
        RULES.add(new ProtocolProjectorRule());
        RULES.add(new ParameterProjectorRule());
        RULES.add(new ProtocolReferenceProjectorRule());
        RULES.add(new RepeatProjectorRule());
        RULES.add(new RecBlockProjectorRule());
        RULES.add(new RecursionProjectorRule());
        RULES.add(new RunProjectorRule());
        RULES.add(new InlineProjectorRule());
        RULES.add(new DoProjectorRule());
        RULES.add(new DataTypeProjectorRule());
        RULES.add(new TypeReferenceProjectorRule());
        RULES.add(new UnorderedProjectorRule());
        RULES.add(new EndProjectorRule());
    }
}

