/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.DirectedChoice;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;

public class DirectedChoiceProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == DirectedChoice.class;
    }

    public Object project(ProtocolProjectorContext context, ModelObject model, Role role, Journal l) {
        DirectedChoice ret = new DirectedChoice();
        DirectedChoice source = (DirectedChoice)model;
        ret.derivedFrom((ModelObject)source);
        if (source.getFromRole() != null && source.getFromRole().equals((Object)role)) {
            for (Role r : source.getToRoles()) {
                ret.getToRoles().add(new Role(r.getName()));
            }
        } else if (source.getFromRole() != null && source.getToRoles().contains(role)) {
            ret.setFromRole(new Role(source.getFromRole()));
        } else {
            ret = null;
        }
        if (ret != null) {
            for (int i = 0; i < source.getOnMessages().size(); ++i) {
                OnMessage om = (OnMessage)context.project((ModelObject)source.getOnMessages().get(i), role, l);
                if (om == null) continue;
                ret.getOnMessages().add(om);
            }
        }
        return ret;
    }
}

