/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.projection.impl;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ParameterDefinition;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.RecBlock;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.projection.impl.ProjectorRule;
import org.scribble.protocol.projection.impl.ProtocolProjectorContext;
import org.scribble.protocol.projection.impl.ProtocolProjectorRule;
import org.scribble.protocol.util.RoleUtil;

public class ProtocolModelProjectorRule
implements ProjectorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == ProtocolModel.class;
    }

    public Object project(ProtocolProjectorContext context, ModelObject model, Role role, Journal l) {
        ProtocolModel ret = new ProtocolModel();
        ProtocolModel source = (ProtocolModel)model;
        ret.derivedFrom((ModelObject)source);
        for (int i = 0; i < source.getImports().size(); ++i) {
            ImportList newImport = (ImportList)context.project((ModelObject)source.getImports().get(i), role, l);
            if (newImport == null) continue;
            ret.getImports().add(newImport);
        }
        Protocol protocol = null;
        Role roleDefn = null;
        for (Role sr : source.getRoles()) {
            if (!sr.equals((Object)role)) continue;
            roleDefn = sr;
            break;
        }
        if (roleDefn == null) {
            l.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.projection.impl.Messages").getString("_UNKNOWN_ROLE"), role.getName()), ret.getProperties());
            ret = null;
        } else {
            Protocol srcprotocol = RoleUtil.getEnclosingProtocol(roleDefn);
            if (srcprotocol != null) {
                protocol = ProtocolProjectorRule.startProtocolProjection(context, srcprotocol, role, l);
                Block srcblock = RoleUtil.getEnclosingBlock((Protocol)srcprotocol, (Role)roleDefn, (boolean)true);
                Block block = null;
                if (srcblock != null) {
                    block = (Block)context.project((ModelObject)srcblock, role, l);
                }
                if (block != null) {
                    if (srcprotocol != source.getProtocol()) {
                        protocol.setName(source.getProtocol().getName());
                        protocol.getParameterDefinitions().clear();
                    }
                    protocol.setBlock(block);
                    Set declaredRoles = RoleUtil.getDeclaredRoles((Block)protocol.getBlock());
                    Set usedRoles = RoleUtil.getUsedRoles((ModelObject)protocol.getBlock());
                    usedRoles.removeAll(declaredRoles);
                    protocol.getParameterDefinitions().clear();
                    for (Role used : usedRoles) {
                        if (used.equals((Object)role)) continue;
                        ParameterDefinition pd = new ParameterDefinition();
                        pd.setName(used.getName());
                        protocol.getParameterDefinitions().add(pd);
                    }
                }
                ProtocolProjectorRule.endProtocolProjection(context, srcprotocol, protocol, role, l);
            }
            ret.setProtocol(protocol);
        }
        if (ret != null && context.getProtocolValidationManager() != null) {
            context.getProtocolValidationManager().validate(context.getProtocolContext(), ret, l);
        }
        return ret;
    }

    protected static Block checkContainingConstructs(Block block) {
        Block ret;
        for (Block cur = ret = block; cur != null && cur.getParent() != null && !(cur.getParent() instanceof Protocol); cur = cur.getParent()) {
            if (cur.getParent().getClass() != RecBlock.class) continue;
            RecBlock rb = new RecBlock();
            rb.derivedFrom(cur.getParent());
            rb.setLabel(((RecBlock)cur.getParent()).getLabel());
            rb.setBlock(ret);
            ret = new Block();
            ret.add((Activity)rb);
        }
        return ret;
    }
}

