/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.Behaviour;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.SinglePathBehaviour;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optional
extends Behaviour
implements SinglePathBehaviour {
    private static final long serialVersionUID = 1791495582908894601L;
    private Block m_block = new Block();
    private List<Role> m_roles = new Vector<Role>();

    public Optional() {
        this.m_block.setParent(this);
    }

    @Override
    public boolean isWaitState() {
        boolean ret = false;
        Role role = this.locatedRole();
        if (role != null && !this.m_roles.contains(role)) {
            ret = true;
        }
        return ret;
    }

    public List<Role> getRoles() {
        return this.m_roles;
    }

    @Override
    public Block getBlock() {
        return this.m_block;
    }

    public void setBlock(Block block) {
        if (this.m_block != null) {
            this.m_block.setParent(null);
        }
        this.m_block = block;
        if (this.m_block != null) {
            this.m_block.setParent(this);
        }
    }

    @Override
    public boolean isStrictScope() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return true;
    }

    @Override
    public boolean isRepetition() {
        return true;
    }

    @Override
    public List<Role> initiatorRoles() {
        List<Role> ret = super.initiatorRoles();
        for (int i = 0; i < this.getRoles().size(); ++i) {
            if (ret.contains(this.getRoles().get(i))) continue;
            ret.add(this.getRoles().get(i));
        }
        return ret;
    }

    @Override
    public List<Role> finalRoles() {
        List<Role> ret = super.finalRoles();
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.start(this);
        if (this.getBlock() != null) {
            this.getBlock().visit(visitor);
        }
        visitor.end(this);
    }
}

