/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.RoleUtil;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;

public class ChoiceValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Choice.class;
    }

    public void validate(ModelObject obj, Journal logger) {
        Set<Role> roles;
        Choice elem = (Choice)obj;
        Role locatedRole = null;
        boolean locatedRoleUsed = false;
        if (elem.enclosingProtocol() != null) {
            locatedRole = elem.enclosingProtocol().getRole();
        }
        if (elem.getFromRole() == null) {
            if (locatedRole == null || elem.getToRole() == null || locatedRole.equals(elem.getToRole())) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_CHOICE_ROLE"), "from"), obj.getProperties());
            }
            if (locatedRole != null) {
                locatedRoleUsed = true;
            }
        } else {
            roles = RoleUtil.getRolesInScope(elem);
            if (!roles.contains(elem.getFromRole())) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), elem.getFromRole().getName()), obj.getProperties());
            }
            if (locatedRole != null && elem.getFromRole().equals(locatedRole)) {
                locatedRoleUsed = true;
            }
        }
        if (elem.getToRole() == null) {
            if (locatedRole == null || elem.getFromRole() == null || locatedRole.equals(elem.getFromRole())) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_CHOICE_ROLE"), "to"), obj.getProperties());
            }
            if (locatedRole != null) {
                locatedRoleUsed = true;
            }
        } else {
            roles = RoleUtil.getRolesInScope(elem);
            if (!roles.contains(elem.getToRole())) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), elem.getToRole().getName()), obj.getProperties());
            }
            if (locatedRole != null && elem.getToRole().equals(locatedRole)) {
                locatedRoleUsed = true;
            }
        }
        if (locatedRole != null && !locatedRoleUsed) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNRELATED_TO_LOCATED_ROLE"), locatedRole.getName()), obj.getProperties());
        }
    }
}

