/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.scribble.common.model.Annotation;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelObject {
    private ModelObject _parent = null;
    private List<Annotation> _annotations = new Vector<Annotation>();
    private Map<String, Object> _properties = new HashMap<String, Object>();

    public ModelObject() {
    }

    public ModelObject(ModelObject obj) {
        this._properties.putAll(obj.getProperties());
        this._annotations.addAll(obj.getAnnotations());
    }

    public ModelObject getParent() {
        return this._parent;
    }

    public void setParent(ModelObject parent) {
        this._parent = parent;
    }

    public void derivedFrom(ModelObject modelObj) {
        if (modelObj != null) {
            this._properties = new HashMap<String, Object>(modelObj.getProperties());
            this._annotations = new Vector<Annotation>(modelObj.getAnnotations());
        }
    }

    public List<Annotation> getAnnotations() {
        return this._annotations;
    }

    public Map<String, Object> getProperties() {
        return this._properties;
    }

    public ProtocolModel getModel() {
        ProtocolModel ret = null;
        ModelObject cur = this;
        while (ret == null && cur != null) {
            if (cur instanceof ProtocolModel) {
                ret = (ProtocolModel)cur;
                continue;
            }
            cur = cur.getParent();
        }
        return ret;
    }

    public abstract void visit(Visitor var1);
}

