/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.RoleUtil;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidatorContext;

public class InteractionValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Interaction.class;
    }

    public void validate(ProtocolValidatorContext pvc, ModelObject obj, Journal logger) {
        Set<Role> roles;
        Interaction elem = (Interaction)obj;
        Role locatedRole = null;
        boolean locatedRoleUsed = false;
        if (elem.getEnclosingProtocol() != null) {
            locatedRole = elem.getEnclosingProtocol().getLocatedRole();
        }
        if (elem.getFromRole() == null) {
            if (locatedRole == null || elem.getToRoles().size() == 0 || elem.getToRoles().contains(locatedRole)) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_INTERACTION_ROLE"), "from"), elem.getProperties());
            }
            if (locatedRole != null) {
                locatedRoleUsed = true;
            }
        } else {
            roles = RoleUtil.getRolesInScope(elem);
            if (!roles.contains(elem.getFromRole())) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), elem.getFromRole().getName()), elem.getFromRole().getProperties());
            }
            if (locatedRole != null && elem.getFromRole().equals(locatedRole)) {
                locatedRoleUsed = true;
            }
        }
        if (elem.getToRoles().size() == 0) {
            if (locatedRole == null || elem.getFromRole() == null || locatedRole.equals(elem.getFromRole())) {
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_INTERACTION_ROLE"), "to"), elem.getProperties());
            }
            if (locatedRole != null) {
                locatedRoleUsed = true;
            }
        } else {
            roles = RoleUtil.getRolesInScope(elem);
            for (Role r : elem.getToRoles()) {
                if (roles.contains(r)) continue;
                logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), r.getName()), r.getProperties());
            }
            if (locatedRole != null && elem.getToRoles().contains(locatedRole)) {
                locatedRoleUsed = true;
            }
        }
        if (locatedRole != null && !locatedRoleUsed) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNRELATED_TO_LOCATED_ROLE"), locatedRole.getName()), elem.getProperties());
        }
    }
}

