/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.validate;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolContext;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.validation.ProtocolValidationManager;

public class ValidateCommand
implements Command {
    private ProtocolValidationManager m_validationManager = null;
    private Journal m_journal = null;
    private ProtocolParserManager m_protocolParserManager = null;

    public void setValidationManager(ProtocolValidationManager vm) {
        this.m_validationManager = vm;
    }

    public void setJournal(Journal journal) {
        this.m_journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this.m_protocolParserManager = parser;
    }

    public String getName() {
        return "validate";
    }

    public String getDescription() {
        return "Validate a Scribble description";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 1) {
            this.m_journal.info("PARSE " + args[0], null);
            File f = new File(args[0]);
            if (!f.exists()) {
                this.m_journal.error("File not found '" + args[0] + "'", null);
            } else {
                try {
                    ProtocolModel model;
                    FileInputStream is = new FileInputStream(f);
                    int index = f.getName().lastIndexOf(46);
                    String sourceType = null;
                    if (index != -1) {
                        sourceType = f.getName().substring(index + 1);
                    }
                    if ((model = this.m_protocolParserManager.parse(sourceType, (InputStream)is, this.m_journal, (ProtocolContext)new DefaultProtocolContext(this.m_protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f.getParentFile())))) != null) {
                        this.m_journal.info("VALIDATE " + args[0], null);
                        this.m_validationManager.validate(model, this.m_journal);
                        ret = true;
                    } else {
                        this.m_journal.error("Protocol model is null", null);
                    }
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    this.m_journal.error("Failed to parse file '" + args[0] + "'", null);
                }
            }
        } else {
            System.err.println("VALIDATE EXPECTING 1 PARAMETER");
        }
        return ret;
    }
}

