package org.seasar.doma.internal.jdbc.sql.node;

import static org.seasar.doma.internal.util.AssertionUtil.assertNotNull;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class ElseNode extends AbstractSqlNode implements SpaceStrippingNode {

  protected final String text;

  public ElseNode(String text) {
    assertNotNull(text);
    this.text = text;
  }

  public String getText() {
    return text;
  }

  @Override
  public void clearChildren() {
    children.clear();
  }

  @Override
  public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
    if (visitor == null) {
      throw new DomaNullPointerException("visitor");
    }
    return visitor.visitElseNode(this, p);
  }
}
