package org.seasar.doma.jdbc.id;

import java.sql.Connection;
import java.sql.Statement;

/** Defines types for auto generated keys. */
public enum AutoGeneratedKeysType {

  /**
   * Indicates to use the default way.
   *
   * @see Connection#prepareStatement(String, int)
   * @see Statement#RETURN_GENERATED_KEYS
   */
  DEFAULT,

  /**
   * Indicates to specify the first column.
   *
   * @see Connection#prepareStatement(String, int[])
   */
  FIRST_COLUMN
}
