package org.seasar.doma.jdbc.query;

import java.util.List;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlLogType;

public interface BatchModifyQuery extends Query {

  List<PreparedSql> getSqls();

  @Override
  PreparedSql getSql();

  @SuppressWarnings("BooleanMethodIsAlwaysInverted")
  boolean isOptimisticLockCheckRequired();

  boolean isAutoGeneratedKeysSupported();

  boolean isExecutable();

  SqlExecutionSkipCause getSqlExecutionSkipCause();

  int getBatchSize();

  SqlLogType getSqlLogType();
}
