/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.function.Supplier;
import org.seasar.doma.FetchType;
import org.seasar.doma.internal.jdbc.command.ResultSetIterator;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.IteratorUtil;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.command.ResultSetRowIndexConsumer;
import org.seasar.doma.jdbc.query.SelectQuery;

public abstract class AbstractIterationHandler<TARGET, RESULT>
implements ResultSetHandler<RESULT> {
    protected final IterationCallback<TARGET, RESULT> iterationCallback;

    public AbstractIterationHandler(IterationCallback<TARGET, RESULT> iterationCallback) {
        AssertionUtil.assertNotNull(iterationCallback);
        this.iterationCallback = iterationCallback;
    }

    @Override
    public Supplier<RESULT> handle(ResultSet resultSet, SelectQuery query, ResultSetRowIndexConsumer consumer) throws SQLException {
        ObjectProvider<TARGET> provider = this.createObjectProvider(query);
        ResultSetIterator<TARGET> iterator = new ResultSetIterator<TARGET>(resultSet, query, consumer, provider);
        try {
            if (query.getFetchType() == FetchType.EAGER) {
                Iterator<TARGET> it = IteratorUtil.copy(iterator);
                return () -> this.iterate(it);
            }
            Object result = this.iterate(iterator);
            return () -> result;
        }
        catch (ResultSetIterator.SQLRuntimeException e) {
            throw e.getCause();
        }
    }

    protected RESULT iterate(Iterator<TARGET> iterator) {
        IterationContext context = new IterationContext();
        RESULT candidate = this.iterationCallback.defaultResult();
        while (!context.isExited() && iterator.hasNext()) {
            TARGET target = iterator.next();
            candidate = this.iterationCallback.iterate(target, context);
        }
        return this.iterationCallback.postIterate(candidate, context);
    }

    protected abstract ObjectProvider<TARGET> createObjectProvider(SelectQuery var1);
}

