/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.seasar.doma.FetchType;
import org.seasar.doma.internal.jdbc.command.ResultSetIterator;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.IteratorUtil;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.command.ResultSetHandler;
import org.seasar.doma.jdbc.command.ResultSetRowIndexConsumer;
import org.seasar.doma.jdbc.query.SelectQuery;

public abstract class AbstractStreamHandler<TARGET, RESULT>
implements ResultSetHandler<RESULT> {
    protected final Function<Stream<TARGET>, RESULT> mapper;

    public AbstractStreamHandler(Function<Stream<TARGET>, RESULT> mapper) {
        AssertionUtil.assertNotNull(mapper);
        this.mapper = mapper;
    }

    @Override
    public Supplier<RESULT> handle(ResultSet resultSet, SelectQuery query, ResultSetRowIndexConsumer consumer) throws SQLException {
        ObjectProvider<TARGET> provider = this.createObjectProvider(query);
        ResultSetIterator<TARGET> iterator = new ResultSetIterator<TARGET>(resultSet, query, consumer, provider);
        try {
            if (query.getFetchType() == FetchType.EAGER) {
                List<TARGET> list = IteratorUtil.toList(iterator);
                return () -> this.mapper.apply(list.stream());
            }
            Spliterator<TARGET> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
            Stream<TARGET> stream = StreamSupport.stream(spliterator, false);
            Object result = this.mapper.apply(stream);
            return () -> result;
        }
        catch (ResultSetIterator.SQLRuntimeException e) {
            throw e.getCause();
        }
    }

    protected abstract ObjectProvider<TARGET> createObjectProvider(SelectQuery var1);
}

