/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.JdbcOutParameterGetter;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcMappable;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ListParameter;
import org.seasar.doma.jdbc.ObjectProvider;
import org.seasar.doma.jdbc.OutParameter;
import org.seasar.doma.jdbc.ResultListParameter;
import org.seasar.doma.jdbc.SingleResultParameter;
import org.seasar.doma.jdbc.SqlParameter;
import org.seasar.doma.jdbc.SqlParameterVisitor;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.query.ModuleQuery;
import org.seasar.doma.jdbc.type.JdbcType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.Wrapper;

public class CallableSqlParameterFetcher {
    protected final ModuleQuery query;

    public CallableSqlParameterFetcher(ModuleQuery query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    public void fetch(CallableStatement callableStatement, List<? extends SqlParameter> parameters) throws SQLException {
        AssertionUtil.assertNotNull((Object)callableStatement, parameters);
        FetchingVisitor fetchingVisitor = new FetchingVisitor(this.query, callableStatement);
        for (SqlParameter sqlParameter : parameters) {
            sqlParameter.accept(fetchingVisitor, null);
        }
    }

    @FunctionalInterface
    protected static interface ResultSetConsumer {
        public void accept(ResultSet var1) throws SQLException;
    }

    protected static class FetchingVisitor
    implements SqlParameterVisitor<Void, Void, SQLException> {
        protected final ModuleQuery query;
        protected final Dialect dialect;
        protected final JdbcMappingVisitor jdbcMappingVisitor;
        protected final CallableStatement callableStatement;
        protected int index = 1;

        public FetchingVisitor(ModuleQuery query, CallableStatement callableStatement) {
            this.query = query;
            this.dialect = query.getConfig().getDialect();
            this.jdbcMappingVisitor = this.dialect.getJdbcMappingVisitor();
            this.callableStatement = callableStatement;
        }

        @Override
        public <BASIC> Void visitInParameter(InParameter<BASIC> parameter, Void p) {
            ++this.index;
            return null;
        }

        @Override
        public <BASIC> Void visitOutParameter(OutParameter<BASIC> parameter, Void p) throws SQLException {
            this.fetchOutParameter(parameter);
            parameter.updateReference();
            ++this.index;
            return null;
        }

        @Override
        public <BASIC, INOUT extends InParameter<BASIC> & OutParameter<BASIC>> Void visitInOutParameter(INOUT parameter, Void p) throws SQLException {
            this.fetchOutParameter(parameter);
            ((OutParameter<BASIC>)parameter).updateReference();
            ++this.index;
            return null;
        }

        @Override
        public <ELEMENT> Void visitListParameter(ListParameter<ELEMENT> parameter, Void p) throws SQLException {
            this.fetchListParameter(parameter);
            return null;
        }

        @Override
        public <BASIC, RESULT> Void visitSingleResultParameter(SingleResultParameter<BASIC, RESULT> parameter, Void p) throws SQLException {
            this.fetchOutParameter(parameter);
            ++this.index;
            return null;
        }

        @Override
        public <ELEMENT> Void visitResultListParameter(ResultListParameter<ELEMENT> parameter, Void p) throws SQLException {
            this.fetchListParameter(parameter);
            return null;
        }

        protected <BASIC> void fetchOutParameter(JdbcMappable<BASIC> parameter) throws SQLException {
            Wrapper<BASIC> wrapper = parameter.getWrapper();
            wrapper.accept(this.jdbcMappingVisitor, new JdbcOutParameterGetter(this.callableStatement, this.index), parameter);
        }

        protected <ELEMENT> void fetchListParameter(ListParameter<ELEMENT> parameter) throws SQLException {
            ObjectProvider provider = parameter.createObjectProvider(this.query);
            this.consumeResultSet(parameter.getName(), resultSet -> parameter.add(provider.get(resultSet)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void consumeResultSet(String parameterName, ResultSetConsumer consumer) throws SQLException {
            if (this.dialect.supportsResultSetReturningAsOutParameter()) {
                JdbcType<ResultSet> resultSetType = this.dialect.getResultSetType();
                ResultSet resultSet = resultSetType.getValue(this.callableStatement, this.index);
                if (resultSet == null) {
                    throw new JdbcException((MessageResource)Message.DOMA2137, this.index, parameterName, this.query.getQualifiedName());
                }
                try {
                    while (resultSet.next()) {
                        consumer.accept(resultSet);
                    }
                }
                finally {
                    JdbcUtil.close(resultSet, this.query.getConfig().getJdbcLogger());
                }
                ++this.index;
            } else {
                ResultSet resultSet = this.callableStatement.getResultSet();
                while (resultSet == null && (this.callableStatement.getMoreResults() || this.callableStatement.getUpdateCount() > -1)) {
                    resultSet = this.callableStatement.getResultSet();
                }
                if (resultSet == null) {
                    throw new JdbcException((MessageResource)Message.DOMA2136, parameterName, this.query.getQualifiedName());
                }
                try {
                    while (resultSet.next()) {
                        consumer.accept(resultSet);
                    }
                }
                finally {
                    this.callableStatement.getMoreResults(1);
                }
            }
        }
    }
}

