/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.AbstractParameterBinder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.InParameter;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.query.Query;

public class PreparedSqlParameterBinder
extends AbstractParameterBinder<PreparedStatement, InParameter<?>> {
    protected final Query query;

    public PreparedSqlParameterBinder(Query query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public void bind(PreparedStatement preparedStatement, List<? extends InParameter<?>> parameters) throws SQLException {
        AssertionUtil.assertNotNull((Object)preparedStatement, parameters);
        int index = 1;
        JdbcMappingVisitor jdbcMappingVisitor = this.query.getConfig().getDialect().getJdbcMappingVisitor();
        for (InParameter<?> parameter : parameters) {
            this.bindInParameter(preparedStatement, parameter, index, jdbcMappingVisitor);
            ++index;
        }
    }
}

