/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dao;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.seasar.doma.internal.jdbc.dao.NeverClosedConnection;
import org.seasar.doma.internal.util.AssertionUtil;

class NeverClosedConnectionProvider
implements DataSource {
    private final NeverClosedConnection connection;

    public NeverClosedConnectionProvider(NeverClosedConnection connection) {
        AssertionUtil.assertNotNull(connection);
        this.connection = connection;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public Connection getConnection(String username, String password) {
        return this.connection;
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLoginTimeout(int seconds) {
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface == null) {
            throw new SQLException("iface must not be null");
        }
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new SQLException("cannot unwrap to " + iface.getName());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

